/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.ClassResolver;
import org.ops4j.gaderian.ErrorHandler;
import org.ops4j.gaderian.Gaderian;
import org.ops4j.gaderian.Location;
import org.ops4j.gaderian.ModuleDescriptorProvider;
import org.ops4j.gaderian.Resource;
import org.ops4j.gaderian.conditional.EvaluationContextImpl;
import org.ops4j.gaderian.conditional.Node;
import org.ops4j.gaderian.conditional.Parser;
import org.ops4j.gaderian.impl.ImplMessages;
import org.ops4j.gaderian.parse.ModuleDescriptor;
import org.ops4j.gaderian.parse.SubModuleDescriptor;
import org.ops4j.gaderian.parse.XmlResourceProcessor;
import org.ops4j.gaderian.util.URLResource;

public class XmlModuleDescriptorProvider
implements ModuleDescriptorProvider {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$ops4j$gaderian$impl$XmlModuleDescriptorProvider == null ? (class$org$ops4j$gaderian$impl$XmlModuleDescriptorProvider = XmlModuleDescriptorProvider.class$("org.ops4j.gaderian.impl.XmlModuleDescriptorProvider")) : class$org$ops4j$gaderian$impl$XmlModuleDescriptorProvider));
    public static final String MODULE_XML = "META-INF/org/ops4j/gaderian/module.xml";
    private List _resources = new ArrayList();
    private List _moduleDescriptors = new ArrayList();
    private ClassResolver _resolver;
    private ErrorHandler _errorHandler;
    private XmlResourceProcessor _processor;
    private Parser _conditionalExpressionParser;
    static /* synthetic */ Class class$org$ops4j$gaderian$impl$XmlModuleDescriptorProvider;

    public XmlModuleDescriptorProvider(ClassResolver resolver) {
        this(resolver, MODULE_XML);
    }

    public XmlModuleDescriptorProvider(ClassResolver resolver, String resourcePath) {
        this._resolver = resolver;
        this._resources.addAll(this.getDescriptorResources(resourcePath, this._resolver));
    }

    public XmlModuleDescriptorProvider(ClassResolver resolver, Resource resource) {
        this._resolver = resolver;
        this._resources.add(resource);
    }

    public XmlModuleDescriptorProvider(ClassResolver resolver, List resources) {
        this._resolver = resolver;
        this._resources.addAll(resources);
    }

    private List getDescriptorResources(String resourcePath, ClassResolver resolver) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing modules visible to " + resolver));
        }
        ArrayList<URLResource> descriptors = new ArrayList<URLResource>();
        ClassLoader loader = resolver.getClassLoader();
        Enumeration<URL> e = null;
        try {
            e = loader.getResources(resourcePath);
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(ImplMessages.unableToFindModules(resolver, ex), ex);
        }
        while (e.hasMoreElements()) {
            URL descriptorURL = e.nextElement();
            descriptors.add(new URLResource(descriptorURL));
        }
        return descriptors;
    }

    public List getModuleDescriptors(ErrorHandler handler) {
        this._errorHandler = handler;
        this._processor = this.getResourceProcessor(this._resolver, handler);
        Iterator i = this._resources.iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            this.processResource(resource);
        }
        this._processor = null;
        this._errorHandler = null;
        return this._moduleDescriptors;
    }

    private void processResource(Resource resource) {
        try {
            ModuleDescriptor md = this._processor.processResource(resource);
            this._moduleDescriptors.add(md);
            this.processSubModules(md);
        }
        catch (RuntimeException ex) {
            this._errorHandler.error(LOG, ex.getMessage(), Gaderian.getLocation(ex), ex);
        }
    }

    private void processSubModules(ModuleDescriptor moduleDescriptor) {
        List subModules = moduleDescriptor.getSubModules();
        if (subModules == null) {
            return;
        }
        Iterator i = subModules.iterator();
        while (i.hasNext()) {
            SubModuleDescriptor smd = (SubModuleDescriptor)i.next();
            Resource descriptorResource = smd.getDescriptor();
            if (descriptorResource.getResourceURL() == null) {
                this._errorHandler.error(LOG, ImplMessages.subModuleDoesNotExist(descriptorResource), smd.getLocation(), null);
                continue;
            }
            if (!this.includeSubModule(smd.getConditionalExpression(), moduleDescriptor.getClassResolver(), smd.getLocation())) continue;
            this.processResource(smd.getDescriptor());
        }
    }

    private boolean includeSubModule(String expression, ClassResolver classResolver, Location location) {
        if (expression == null) {
            return true;
        }
        if (this._conditionalExpressionParser == null) {
            this._conditionalExpressionParser = new Parser();
        }
        try {
            Node node = this._conditionalExpressionParser.parse(expression);
            return node.evaluate(new EvaluationContextImpl(classResolver));
        }
        catch (RuntimeException ex) {
            this._errorHandler.error(LOG, ex.getMessage(), location, ex);
            return false;
        }
    }

    protected XmlResourceProcessor getResourceProcessor(ClassResolver resolver, ErrorHandler handler) {
        return new XmlResourceProcessor(resolver, handler);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

