/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.ErrorHandler;
import org.ops4j.gaderian.Location;
import org.ops4j.gaderian.SymbolSource;
import org.ops4j.gaderian.impl.ImplMessages;

public class SymbolExpander {
    private ErrorHandler _errorHandler;
    private SymbolSource _source;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$ops4j$gaderian$impl$SymbolExpander == null ? (class$org$ops4j$gaderian$impl$SymbolExpander = SymbolExpander.class$("org.ops4j.gaderian.impl.SymbolExpander")) : class$org$ops4j$gaderian$impl$SymbolExpander));
    private static final int STATE_START = 0;
    private static final int STATE_DOLLAR = 1;
    private static final int STATE_COLLECT_SYMBOL_NAME = 2;
    static /* synthetic */ Class class$org$ops4j$gaderian$impl$SymbolExpander;

    public SymbolExpander(ErrorHandler handler, SymbolSource source) {
        this._errorHandler = handler;
        this._source = source;
    }

    public String expandSymbols(String text, Location location) {
        StringBuffer result = new StringBuffer(text.length());
        char[] buffer = text.toCharArray();
        int state = 0;
        int blockStart = 0;
        int blockLength = 0;
        int symbolStart = -1;
        int symbolLength = 0;
        int i = 0;
        int braceDepth = 0;
        boolean anySymbols = false;
        block5: while (i < buffer.length) {
            char ch = buffer[i];
            switch (state) {
                case 0: {
                    if (ch == '$') {
                        state = 1;
                        ++i;
                        continue block5;
                    }
                    ++blockLength;
                    ++i;
                    continue block5;
                }
                case 1: {
                    if (ch == '{') {
                        state = 2;
                        symbolStart = ++i;
                        symbolLength = 0;
                        braceDepth = 1;
                        continue block5;
                    }
                    if (ch == '$') {
                        anySymbols = true;
                        if (blockLength > 0) {
                            result.append(buffer, blockStart, blockLength);
                        }
                        result.append(ch);
                        blockStart = ++i;
                        blockLength = 0;
                        state = 0;
                        continue block5;
                    }
                    ++blockLength;
                    state = 0;
                    continue block5;
                }
                case 2: {
                    if (ch != '}') {
                        if (ch == '{') {
                            ++braceDepth;
                        }
                        ++i;
                        ++symbolLength;
                        continue block5;
                    }
                    if (--braceDepth > 0) {
                        ++i;
                        ++symbolLength;
                        continue block5;
                    }
                    if (symbolLength == 0) {
                        blockLength += 3;
                    }
                    if (blockLength > 0) {
                        result.append(buffer, blockStart, blockLength);
                    }
                    if (symbolLength > 0) {
                        String variableName = text.substring(symbolStart, symbolStart + symbolLength);
                        result.append(this.expandSymbol(variableName, location));
                        anySymbols = true;
                    }
                    blockStart = ++i;
                    blockLength = 0;
                    state = 0;
                    continue block5;
                }
            }
        }
        if (!anySymbols) {
            return text;
        }
        if (state == 1) {
            ++blockLength;
        }
        if (state == 2) {
            blockLength += symbolLength + 2;
        }
        if (blockLength > 0) {
            result.append(buffer, blockStart, blockLength);
        }
        return result.toString();
    }

    private String expandSymbol(String name, Location location) {
        String value = this._source.valueForSymbol(name);
        if (value != null) {
            return value;
        }
        this._errorHandler.error(LOG, ImplMessages.noSuchSymbol(name), location, null);
        return "${" + name + "}";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

