/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.ShutdownCoordinator;
import org.ops4j.gaderian.events.RegistryShutdownListener;
import org.ops4j.gaderian.impl.ImplMessages;
import org.ops4j.gaderian.util.EventListenerList;

public final class ShutdownCoordinatorImpl
implements ShutdownCoordinator {
    private final Log _log;
    private Set alreadyShutdown;
    private EventListenerList _listenerList;
    static /* synthetic */ Class class$org$ops4j$gaderian$impl$ShutdownCoordinatorImpl;

    public ShutdownCoordinatorImpl() {
        this(LogFactory.getLog((Class)(class$org$ops4j$gaderian$impl$ShutdownCoordinatorImpl == null ? (class$org$ops4j$gaderian$impl$ShutdownCoordinatorImpl = ShutdownCoordinatorImpl.class$("org.ops4j.gaderian.impl.ShutdownCoordinatorImpl")) : class$org$ops4j$gaderian$impl$ShutdownCoordinatorImpl)));
    }

    public ShutdownCoordinatorImpl(Log log) {
        this._log = log;
    }

    public synchronized void addRegistryShutdownListener(RegistryShutdownListener s) {
        if (this._listenerList == null) {
            this._listenerList = new EventListenerList();
        }
        this._listenerList.addListener(s);
    }

    public synchronized void removeRegistryShutdownListener(RegistryShutdownListener s) {
        if (this._listenerList != null) {
            this._listenerList.removeListener(s);
        }
    }

    public void shutdown() {
        if (this._listenerList == null) {
            return;
        }
        Iterator i = this._listenerList.getListeners();
        this._listenerList = null;
        while (i.hasNext()) {
            RegistryShutdownListener s = (RegistryShutdownListener)i.next();
            this.shutdown(s);
        }
        this._listenerList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(RegistryShutdownListener s) {
        Long id;
        if (this.alreadyShutdown == null) {
            this.alreadyShutdown = new HashSet();
        }
        if (!this.alreadyShutdown.contains(id = new Long(System.identityHashCode(s)))) {
            try {
                s.registryDidShutdown();
            }
            catch (RuntimeException ex) {
                this._log.error((Object)ImplMessages.shutdownCoordinatorFailure(s, ex), (Throwable)ex);
            }
            finally {
                this.alreadyShutdown.add(id);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

