/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.Gaderian;
import org.ops4j.gaderian.Occurances;
import org.ops4j.gaderian.ShutdownCoordinator;
import org.ops4j.gaderian.events.RegistryShutdownListener;
import org.ops4j.gaderian.impl.AbstractExtensionPoint;
import org.ops4j.gaderian.impl.ConstructableServicePoint;
import org.ops4j.gaderian.impl.ImplMessages;
import org.ops4j.gaderian.internal.ServiceImplementationConstructor;
import org.ops4j.gaderian.internal.ServiceInterceptorContribution;
import org.ops4j.gaderian.internal.ServiceModel;
import org.ops4j.gaderian.internal.ServiceModelFactory;
import org.ops4j.gaderian.order.Orderer;
import org.ops4j.gaderian.schema.Schema;
import org.ops4j.gaderian.service.InterfaceSynthesizer;
import org.ops4j.gaderian.util.ToStringBuilder;

public final class ServicePointImpl
extends AbstractExtensionPoint
implements ConstructableServicePoint {
    private Object _service;
    private boolean _building;
    private String _serviceInterfaceName;
    private Class _serviceInterface;
    private Class _declaredInterface;
    private ServiceImplementationConstructor _defaultServiceConstructor;
    private ServiceImplementationConstructor _serviceConstructor;
    private List _interceptorContributions;
    private boolean _interceptorsOrdered;
    private Schema _parametersSchema;
    private Occurances _parametersCount;
    private String _serviceModel;
    private ShutdownCoordinator _shutdownCoordinator;
    private ServiceModel _serviceModelObject;
    static /* synthetic */ Class class$org$ops4j$gaderian$service$InterfaceSynthesizer;

    protected void extendDescription(ToStringBuilder builder) {
        if (this._service != null) {
            builder.append("service", this._service);
        }
        builder.append("serviceInterfaceName", this._serviceInterfaceName);
        builder.append("defaultServiceConstructor", this._defaultServiceConstructor);
        builder.append("serviceConstructor", this._serviceConstructor);
        builder.append("interceptorContributions", this._interceptorContributions);
        builder.append("parametersSchema", this._parametersSchema);
        builder.append("parametersCount", this._parametersCount);
        builder.append("serviceModel", this._serviceModel);
        if (this._building) {
            builder.append("building", this._building);
        }
    }

    public void addInterceptorContribution(ServiceInterceptorContribution contribution) {
        if (this._interceptorContributions == null) {
            this._interceptorContributions = new ArrayList();
        }
        this._interceptorContributions.add(contribution);
    }

    public synchronized Class getServiceInterface() {
        if (this._serviceInterface == null) {
            this._serviceInterface = this.lookupServiceInterface();
        }
        return this._serviceInterface;
    }

    public synchronized Class getDeclaredInterface() {
        if (this._declaredInterface == null) {
            this._declaredInterface = this.lookupDeclaredInterface();
        }
        return this._declaredInterface;
    }

    public String getServiceInterfaceClassName() {
        return this._serviceInterfaceName;
    }

    private Class lookupDeclaredInterface() {
        Class result = null;
        try {
            result = this.getModule().resolveType(this._serviceInterfaceName);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ImplMessages.badInterface(this._serviceInterfaceName, this.getExtensionPointId()), this.getLocation(), ex);
        }
        return result;
    }

    private Class lookupServiceInterface() {
        Class declaredInterface = this.getDeclaredInterface();
        if (declaredInterface.isInterface()) {
            return declaredInterface;
        }
        InterfaceSynthesizer is = (InterfaceSynthesizer)this.getModule().getService("gaderian.InterfaceSynthesizer", class$org$ops4j$gaderian$service$InterfaceSynthesizer == null ? (class$org$ops4j$gaderian$service$InterfaceSynthesizer = ServicePointImpl.class$("org.ops4j.gaderian.service.InterfaceSynthesizer")) : class$org$ops4j$gaderian$service$InterfaceSynthesizer);
        return is.synthesizeInterface(declaredInterface);
    }

    public void setServiceConstructor(ServiceImplementationConstructor contribution, boolean defaultConstructor) {
        if (defaultConstructor) {
            this._defaultServiceConstructor = contribution;
        } else {
            this._serviceConstructor = contribution;
        }
    }

    public void setServiceInterfaceName(String string) {
        this._serviceInterfaceName = string;
    }

    public void setParametersSchema(Schema schema) {
        this._parametersSchema = schema;
    }

    public Schema getParametersSchema() {
        return this._parametersSchema;
    }

    public ServiceImplementationConstructor getServiceConstructor(boolean defaultConstructor) {
        return defaultConstructor ? this._defaultServiceConstructor : this._serviceConstructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Object getService() {
        if (this._service == null) {
            if (this._building) {
                throw new ApplicationRuntimeException(ImplMessages.recursiveServiceBuild(this));
            }
            this._building = true;
            try {
                ServiceModelFactory factory = this.getModule().getServiceModelFactory(this.getServiceModel());
                this._serviceModelObject = factory.createServiceModelForService(this);
                this._service = this._serviceModelObject.getService();
            }
            finally {
                this._building = false;
            }
        }
        return this._service;
    }

    public Object getService(Class serviceInterface) {
        Object result = this.getService();
        if (!serviceInterface.isAssignableFrom(result.getClass())) {
            throw new ApplicationRuntimeException(ImplMessages.serviceWrongInterface(this, serviceInterface), this.getLocation(), null);
        }
        return result;
    }

    public String getServiceModel() {
        return this._serviceModel;
    }

    public void setServiceModel(String model) {
        this._serviceModel = model;
    }

    public void clearConstructorInformation() {
        this._serviceConstructor = null;
        this._interceptorContributions = null;
    }

    public List getOrderedInterceptorContributions() {
        if (!this._interceptorsOrdered) {
            this._interceptorContributions = this.orderInterceptors();
            this._interceptorsOrdered = true;
        }
        return this._interceptorContributions;
    }

    private List orderInterceptors() {
        if (Gaderian.isEmpty(this._interceptorContributions)) {
            return null;
        }
        Log log = LogFactory.getLog((String)this.getExtensionPointId());
        Orderer orderer = new Orderer(log, this.getModule().getErrorHandler(), ImplMessages.interceptorContribution());
        Iterator i = this._interceptorContributions.iterator();
        while (i.hasNext()) {
            ServiceInterceptorContribution sic = (ServiceInterceptorContribution)i.next();
            orderer.add(sic, sic.getName(), sic.getPrecedingInterceptorIds(), sic.getFollowingInterceptorIds());
        }
        return orderer.getOrderedObjects();
    }

    public void setShutdownCoordinator(ShutdownCoordinator coordinator) {
        this._shutdownCoordinator = coordinator;
    }

    public void addRegistryShutdownListener(RegistryShutdownListener listener) {
        this._shutdownCoordinator.addRegistryShutdownListener(listener);
    }

    public void forceServiceInstantiation() {
        this.getService();
        this._serviceModelObject.instantiateService();
    }

    public Occurances getParametersCount() {
        return this._parametersCount;
    }

    public void setParametersCount(Occurances occurances) {
        this._parametersCount = occurances;
    }

    public ServiceImplementationConstructor getServiceConstructor() {
        return this._serviceConstructor == null ? this._defaultServiceConstructor : this._serviceConstructor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

