/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.ops4j.gaderian.ErrorHandler;
import org.ops4j.gaderian.Location;
import org.ops4j.gaderian.Occurances;
import org.ops4j.gaderian.ShutdownCoordinator;
import org.ops4j.gaderian.conditional.EvaluationContextImpl;
import org.ops4j.gaderian.conditional.Node;
import org.ops4j.gaderian.conditional.Parser;
import org.ops4j.gaderian.impl.ConfigurationPointImpl;
import org.ops4j.gaderian.impl.ContributionImpl;
import org.ops4j.gaderian.impl.ImplMessages;
import org.ops4j.gaderian.impl.ModuleImpl;
import org.ops4j.gaderian.impl.RegistryAssembly;
import org.ops4j.gaderian.impl.RegistryInfrastructureImpl;
import org.ops4j.gaderian.impl.ServiceInterceptorContributionImpl;
import org.ops4j.gaderian.impl.ServicePointImpl;
import org.ops4j.gaderian.impl.ShutdownCoordinatorImpl;
import org.ops4j.gaderian.internal.ConfigurationPoint;
import org.ops4j.gaderian.internal.Module;
import org.ops4j.gaderian.internal.RegistryInfrastructure;
import org.ops4j.gaderian.internal.ServicePoint;
import org.ops4j.gaderian.parse.ConfigurationPointDescriptor;
import org.ops4j.gaderian.parse.ContributionDescriptor;
import org.ops4j.gaderian.parse.DependencyDescriptor;
import org.ops4j.gaderian.parse.ImplementationDescriptor;
import org.ops4j.gaderian.parse.InstanceBuilder;
import org.ops4j.gaderian.parse.InterceptorDescriptor;
import org.ops4j.gaderian.parse.ModuleDescriptor;
import org.ops4j.gaderian.parse.ServicePointDescriptor;
import org.ops4j.gaderian.schema.ElementModel;
import org.ops4j.gaderian.schema.Schema;
import org.ops4j.gaderian.schema.impl.SchemaImpl;
import org.ops4j.gaderian.util.IdUtils;

public class RegistryInfrastructureConstructor {
    private ErrorHandler _errorHandler;
    private Log _log;
    private RegistryAssembly _assembly;
    private Parser _conditionalExpressionParser;
    private Map _moduleDescriptors = new HashMap();
    private Map _modules = new HashMap();
    private Map _schemas = new HashMap();
    private ElementModel _assemblyElementModel;
    private Map _servicePoints = new HashMap();
    private Map _configurationPoints = new HashMap();
    private ShutdownCoordinator _shutdownCoordinator = new ShutdownCoordinatorImpl();

    public RegistryInfrastructureConstructor(ErrorHandler errorHandler, Log log, RegistryAssembly assembly) {
        this._errorHandler = errorHandler;
        this._log = log;
        this._assembly = assembly;
    }

    public RegistryInfrastructure constructRegistryInfrastructure(Locale locale) {
        RegistryInfrastructureImpl result = new RegistryInfrastructureImpl(this._errorHandler, locale);
        this.addServiceAndConfigurationPoints(result);
        this.addImplementationsAndContributions();
        this.checkForMissingServices();
        this.checkContributionCounts();
        result.setShutdownCoordinator(this._shutdownCoordinator);
        this.addModulesToRegistry(result);
        return result;
    }

    public void addModuleDescriptor(ModuleDescriptor md) {
        String id = md.getModuleId();
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Processing module " + id));
        }
        if (this._modules.containsKey(id)) {
            Module existing = (Module)this._modules.get(id);
            this._errorHandler.error(this._log, ImplMessages.duplicateModuleId(id, existing.getLocation(), md.getLocation()), null, null);
            return;
        }
        ModuleImpl module = new ModuleImpl();
        module.setLocation(md.getLocation());
        module.setModuleId(id);
        module.setPackageName(md.getPackageName());
        module.setClassResolver(md.getClassResolver());
        if (RegistryInfrastructureConstructor.size(md.getDependencies()) > 0) {
            this._assembly.addPostProcessor(new ModuleDependencyChecker(md));
        }
        Iterator schemas = md.getSchemas().iterator();
        while (schemas.hasNext()) {
            SchemaImpl schema = (SchemaImpl)schemas.next();
            schema.setModule(module);
            this._schemas.put(IdUtils.qualify(id, schema.getId()), schema);
        }
        this._modules.put(id, module);
        this._moduleDescriptors.put(id, md);
    }

    private void addServiceAndConfigurationPoints(RegistryInfrastructureImpl infrastructure) {
        Iterator i = this._moduleDescriptors.values().iterator();
        while (i.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)i.next();
            String id = md.getModuleId();
            ModuleImpl module = (ModuleImpl)this._modules.get(id);
            this.addServicePoints(infrastructure, module, md);
            this.addConfigurationPoints(infrastructure, module, md);
        }
    }

    private void addServicePoints(RegistryInfrastructureImpl infrastructure, Module module, ModuleDescriptor md) {
        String moduleId = md.getModuleId();
        List services = md.getServicePoints();
        int count = RegistryInfrastructureConstructor.size(services);
        for (int i = 0; i < count; ++i) {
            ServicePointDescriptor sd = (ServicePointDescriptor)services.get(i);
            String pointId = moduleId + "." + sd.getId();
            ServicePoint existingPoint = (ServicePoint)this._servicePoints.get(pointId);
            if (existingPoint != null) {
                this._errorHandler.error(this._log, ImplMessages.duplicateExtensionPointId(pointId, existingPoint), sd.getLocation(), null);
                continue;
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Creating service point " + pointId));
            }
            ServicePointImpl point = new ServicePointImpl();
            point.setExtensionPointId(pointId);
            point.setLocation(sd.getLocation());
            point.setModule(module);
            point.setServiceInterfaceName(sd.getInterfaceClassName());
            point.setParametersSchema(this.findParametersSchema(sd.getParametersSchema(), module, sd.getParametersSchemaId(), point.getLocation()));
            point.setParametersCount(sd.getParametersCount());
            point.setVisibility(sd.getVisibility());
            point.setShutdownCoordinator(this._shutdownCoordinator);
            infrastructure.addServicePoint(point);
            this._servicePoints.put(pointId, point);
            this.addInternalImplementations(module, pointId, sd);
        }
    }

    private void addConfigurationPoints(RegistryInfrastructureImpl registry, Module module, ModuleDescriptor md) {
        String moduleId = md.getModuleId();
        List points = md.getConfigurationPoints();
        int count = RegistryInfrastructureConstructor.size(points);
        for (int i = 0; i < count; ++i) {
            ConfigurationPointDescriptor cpd = (ConfigurationPointDescriptor)points.get(i);
            String pointId = moduleId + "." + cpd.getId();
            ConfigurationPoint existingPoint = (ConfigurationPoint)this._configurationPoints.get(pointId);
            if (existingPoint != null) {
                this._errorHandler.error(this._log, ImplMessages.duplicateExtensionPointId(pointId, existingPoint), cpd.getLocation(), null);
                continue;
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Creating configuration point " + pointId));
            }
            ConfigurationPointImpl point = new ConfigurationPointImpl();
            point.setExtensionPointId(pointId);
            point.setLocation(cpd.getLocation());
            point.setModule(module);
            point.setExpectedCount(cpd.getCount());
            point.setContributionsSchema(this.findContributionsSchema(cpd.getContributionsSchema(), module, cpd.getContributionsSchemaId(), cpd.getLocation()));
            point.setVisibility(cpd.getVisibility());
            point.setShutdownCoordinator(this._shutdownCoordinator);
            registry.addConfigurationPoint(point);
            this._configurationPoints.put(pointId, point);
        }
    }

    private void addContributionElements(Module sourceModule, ConfigurationPointImpl point, List elements) {
        if (RegistryInfrastructureConstructor.size(elements) == 0) {
            return;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Adding contributions to configuration point " + point.getExtensionPointId()));
        }
        ContributionImpl c = new ContributionImpl();
        c.setContributingModule(sourceModule);
        c.addElements(elements);
        point.addContribution(c);
    }

    private void addModulesToRegistry(RegistryInfrastructureImpl registry) {
        Iterator i = this._modules.values().iterator();
        while (i.hasNext()) {
            ModuleImpl module = (ModuleImpl)i.next();
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Adding module " + module.getModuleId() + " to registry"));
            }
            module.setRegistry(registry);
        }
    }

    private void addImplementationsAndContributions() {
        Iterator i = this._moduleDescriptors.values().iterator();
        while (i.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)i.next();
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Adding contributions from module " + md.getModuleId()));
            }
            this.addImplementations(md);
            this.addContributions(md);
        }
    }

    private void addImplementations(ModuleDescriptor md) {
        String moduleId = md.getModuleId();
        Module sourceModule = (Module)this._modules.get(moduleId);
        List implementations = md.getImplementations();
        int count = RegistryInfrastructureConstructor.size(implementations);
        for (int i = 0; i < count; ++i) {
            ImplementationDescriptor impl = (ImplementationDescriptor)implementations.get(i);
            if (!this.includeContribution(impl.getConditionalExpression(), sourceModule, impl.getLocation())) continue;
            String pointId = impl.getServiceId();
            String qualifiedId = IdUtils.qualify(moduleId, pointId);
            this.addImplementations(sourceModule, qualifiedId, impl);
        }
    }

    private void addContributions(ModuleDescriptor md) {
        String moduleId = md.getModuleId();
        Module sourceModule = (Module)this._modules.get(moduleId);
        List contributions = md.getContributions();
        int count = RegistryInfrastructureConstructor.size(contributions);
        for (int i = 0; i < count; ++i) {
            ContributionDescriptor cd = (ContributionDescriptor)contributions.get(i);
            if (!this.includeContribution(cd.getConditionalExpression(), sourceModule, cd.getLocation())) continue;
            String pointId = cd.getConfigurationId();
            String qualifiedId = IdUtils.qualify(moduleId, pointId);
            ConfigurationPointImpl point = (ConfigurationPointImpl)this._configurationPoints.get(qualifiedId);
            if (point == null) {
                this._errorHandler.error(this._log, ImplMessages.unknownConfigurationPoint(moduleId, cd), cd.getLocation(), null);
                continue;
            }
            if (!point.visibleToModule(sourceModule)) {
                this._errorHandler.error(this._log, ImplMessages.configurationPointNotVisible(point, sourceModule), cd.getLocation(), null);
                continue;
            }
            this.addContributionElements(sourceModule, point, cd.getElements());
        }
    }

    private Schema findParametersSchema(SchemaImpl schema, Module module, String schemaId, Location location) {
        SchemaImpl result = this.findSchema(schema, module, schemaId, location);
        if (result != null && !result.getElementModel().contains(this.getAssemblyElementModel())) {
            result.addElementModel(this.getAssemblyElementModel());
        }
        return result;
    }

    private Schema findContributionsSchema(SchemaImpl schema, Module module, String schemaId, Location location) {
        return this.findSchema(schema, module, schemaId, location);
    }

    private SchemaImpl findSchema(SchemaImpl schema, Module module, String schemaId, Location location) {
        SchemaImpl result = null;
        if (schema != null) {
            result = schema;
            result.setModule(module);
        } else if (schemaId != null) {
            String moduleId = module.getModuleId();
            String qualifiedId = IdUtils.qualify(moduleId, schemaId);
            result = this.getSchema(qualifiedId, moduleId, location);
        }
        return result;
    }

    private SchemaImpl getSchema(String schemaId, String referencingModule, Location reference) {
        SchemaImpl schema = (SchemaImpl)this._schemas.get(schemaId);
        if (schema == null) {
            this._errorHandler.error(this._log, ImplMessages.unableToResolveSchema(schemaId), reference, null);
        } else if (!schema.visibleToModule(referencingModule)) {
            this._errorHandler.error(this._log, ImplMessages.schemaNotVisible(schemaId, referencingModule), reference, null);
            schema = null;
        }
        return schema;
    }

    private ElementModel getAssemblyElementModel() {
        Schema assemblySchema;
        if (this._assemblyElementModel == null && (assemblySchema = (Schema)this._schemas.get("gaderian.Assembly")) != null) {
            this._assemblyElementModel = (ElementModel)assemblySchema.getElementModel().get(0);
        }
        return this._assemblyElementModel;
    }

    private void addInternalImplementations(Module sourceModule, String pointId, ServicePointDescriptor spd) {
        InstanceBuilder builder = spd.getInstanceBuilder();
        List interceptors = spd.getInterceptors();
        if (builder == null && interceptors == null) {
            return;
        }
        if (builder != null) {
            this.addServiceInstanceBuilder(sourceModule, pointId, builder, true);
        }
        if (interceptors == null) {
            return;
        }
        int count = RegistryInfrastructureConstructor.size(interceptors);
        for (int i = 0; i < count; ++i) {
            InterceptorDescriptor id = (InterceptorDescriptor)interceptors.get(i);
            this.addInterceptor(sourceModule, pointId, id);
        }
    }

    private void addImplementations(Module sourceModule, String pointId, ImplementationDescriptor id) {
        InstanceBuilder builder = id.getInstanceBuilder();
        List interceptors = id.getInterceptors();
        if (builder != null) {
            this.addServiceInstanceBuilder(sourceModule, pointId, builder, false);
        }
        int count = RegistryInfrastructureConstructor.size(interceptors);
        for (int i = 0; i < count; ++i) {
            InterceptorDescriptor ind = (InterceptorDescriptor)interceptors.get(i);
            this.addInterceptor(sourceModule, pointId, ind);
        }
    }

    private void addServiceInstanceBuilder(Module sourceModule, String pointId, InstanceBuilder builder, boolean isDefault) {
        ServicePointImpl point;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Adding " + builder + " to service extension point " + pointId));
        }
        if ((point = (ServicePointImpl)this._servicePoints.get(pointId)) == null) {
            this._errorHandler.error(this._log, ImplMessages.unknownServicePoint(sourceModule, pointId), builder.getLocation(), null);
            return;
        }
        if (!point.visibleToModule(sourceModule)) {
            this._errorHandler.error(this._log, ImplMessages.servicePointNotVisible(point, sourceModule), builder.getLocation(), null);
            return;
        }
        if (point.getServiceConstructor(isDefault) != null) {
            this._errorHandler.error(this._log, ImplMessages.duplicateFactory(sourceModule, pointId, point), builder.getLocation(), null);
            return;
        }
        point.setServiceModel(builder.getServiceModel());
        point.setServiceConstructor(builder.createConstructor(point, sourceModule), isDefault);
    }

    private void addInterceptor(Module sourceModule, String pointId, InterceptorDescriptor id) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Adding " + id + " to service extension point " + pointId));
        }
        ServicePointImpl point = (ServicePointImpl)this._servicePoints.get(pointId);
        String sourceModuleId = sourceModule.getModuleId();
        if (point == null) {
            this._errorHandler.error(this._log, ImplMessages.unknownServicePoint(sourceModule, pointId), id.getLocation(), null);
            return;
        }
        if (!point.visibleToModule(sourceModule)) {
            this._errorHandler.error(this._log, ImplMessages.servicePointNotVisible(point, sourceModule), id.getLocation(), null);
            return;
        }
        ServiceInterceptorContributionImpl sic = new ServiceInterceptorContributionImpl();
        sic.setFactoryServiceId(IdUtils.qualify(sourceModuleId, id.getFactoryServiceId()));
        sic.setLocation(id.getLocation());
        sic.setFollowingInterceptorIds(IdUtils.qualifyList(sourceModuleId, id.getBefore()));
        sic.setPrecedingInterceptorIds(IdUtils.qualifyList(sourceModuleId, id.getAfter()));
        sic.setName(id.getName() != null ? IdUtils.qualify(sourceModuleId, id.getName()) : null);
        sic.setContributingModule(sourceModule);
        sic.setParameters(id.getParameters());
        point.addInterceptorContribution(sic);
    }

    private void checkForMissingServices() {
        Iterator i = this._servicePoints.values().iterator();
        while (i.hasNext()) {
            ServicePointImpl point = (ServicePointImpl)i.next();
            if (point.getServiceConstructor() != null) continue;
            this._errorHandler.error(this._log, ImplMessages.missingService(point), null, null);
        }
    }

    private void checkContributionCounts() {
        Iterator i = this._configurationPoints.values().iterator();
        while (i.hasNext()) {
            int actual;
            ConfigurationPointImpl point = (ConfigurationPointImpl)i.next();
            Occurances expected = point.getExpectedCount();
            if (expected.inRange(actual = point.getContributionCount())) continue;
            this._errorHandler.error(this._log, ImplMessages.wrongNumberOfContributions(point, actual, expected), point.getLocation(), null);
        }
    }

    private boolean includeContribution(String expression, Module module, Location location) {
        if (expression == null) {
            return true;
        }
        if (this._conditionalExpressionParser == null) {
            this._conditionalExpressionParser = new Parser();
        }
        try {
            Node node = this._conditionalExpressionParser.parse(expression);
            return node.evaluate(new EvaluationContextImpl(module.getClassResolver()));
        }
        catch (RuntimeException ex) {
            this._errorHandler.error(this._log, ex.getMessage(), location, ex);
            return false;
        }
    }

    private static int size(Collection c) {
        return c == null ? 0 : c.size();
    }

    private class ModuleDependencyChecker
    implements Runnable {
        private ModuleDescriptor _source;

        public ModuleDependencyChecker(ModuleDescriptor source) {
            this._source = source;
        }

        public void run() {
            List dependencies = this._source.getDependencies();
            int count = RegistryInfrastructureConstructor.size(dependencies);
            for (int i = 0; i < count; ++i) {
                DependencyDescriptor dependency = (DependencyDescriptor)dependencies.get(i);
                this.checkDependency(dependency);
            }
        }

        private void checkDependency(DependencyDescriptor dependency) {
            ModuleDescriptor requiredModule = (ModuleDescriptor)RegistryInfrastructureConstructor.this._moduleDescriptors.get(dependency.getModuleId());
            if (requiredModule == null) {
                RegistryInfrastructureConstructor.this._errorHandler.error(RegistryInfrastructureConstructor.this._log, ImplMessages.dependencyOnUnknownModule(dependency), dependency.getLocation(), null);
                return;
            }
            if (dependency.getVersion() != null && !dependency.getVersion().equals(requiredModule.getVersion())) {
                RegistryInfrastructureConstructor.this._errorHandler.error(RegistryInfrastructureConstructor.this._log, ImplMessages.dependencyVersionMismatch(dependency), dependency.getLocation(), null);
                return;
            }
        }
    }
}

