/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.ErrorHandler;
import org.ops4j.gaderian.ModuleDescriptorProvider;
import org.ops4j.gaderian.Registry;
import org.ops4j.gaderian.impl.DefaultClassResolver;
import org.ops4j.gaderian.impl.DefaultErrorHandler;
import org.ops4j.gaderian.impl.RegistryAssemblyImpl;
import org.ops4j.gaderian.impl.RegistryImpl;
import org.ops4j.gaderian.impl.RegistryInfrastructureConstructor;
import org.ops4j.gaderian.impl.XmlModuleDescriptorProvider;
import org.ops4j.gaderian.internal.RegistryInfrastructure;
import org.ops4j.gaderian.parse.ModuleDescriptor;

public final class RegistryBuilder {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$ops4j$gaderian$impl$RegistryBuilder == null ? (class$org$ops4j$gaderian$impl$RegistryBuilder = RegistryBuilder.class$("org.ops4j.gaderian.impl.RegistryBuilder")) : class$org$ops4j$gaderian$impl$RegistryBuilder));
    private ErrorHandler _errorHandler;
    private RegistryAssemblyImpl _registryAssembly;
    private Set _moduleDescriptorProviders;
    private RegistryInfrastructureConstructor _constructor;
    static /* synthetic */ Class class$org$ops4j$gaderian$impl$RegistryBuilder;

    public RegistryBuilder() {
        this(new DefaultErrorHandler());
    }

    public RegistryBuilder(ErrorHandler handler) {
        this._errorHandler = handler;
        this._registryAssembly = new RegistryAssemblyImpl();
        this._moduleDescriptorProviders = new HashSet();
        this._constructor = new RegistryInfrastructureConstructor(handler, LOG, this._registryAssembly);
    }

    public void addModuleDescriptorProvider(ModuleDescriptorProvider provider) {
        this._moduleDescriptorProviders.add(provider);
    }

    public Registry constructRegistry(Locale locale) {
        Iterator i = this._moduleDescriptorProviders.iterator();
        while (i.hasNext()) {
            ModuleDescriptorProvider provider = (ModuleDescriptorProvider)i.next();
            this.processModuleDescriptorProvider(provider);
        }
        this._registryAssembly.performPostProcessing();
        RegistryInfrastructure infrastructure = this._constructor.constructRegistryInfrastructure(locale);
        infrastructure.startup();
        return new RegistryImpl(infrastructure);
    }

    private void processModuleDescriptorProvider(ModuleDescriptorProvider provider) {
        List descriptors = provider.getModuleDescriptors(this._errorHandler);
        Iterator i = descriptors.iterator();
        while (i.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)i.next();
            this._constructor.addModuleDescriptor(md);
        }
    }

    public void addDefaultModuleDescriptorProvider() {
        this.addModuleDescriptorProvider(new XmlModuleDescriptorProvider(new DefaultClassResolver()));
    }

    public static Registry constructDefaultRegistry() {
        RegistryBuilder builder = new RegistryBuilder();
        builder.addDefaultModuleDescriptorProvider();
        return builder.constructRegistry(Locale.getDefault());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (!LOG.isErrorEnabled()) {
            System.err.println("********************************************************************************");
            System.err.println("* L O G G I N G   C O N F I G U R A T I O N   E R R O R                        *");
            System.err.println("* ---------------------------------------------------------------------------- *");
            System.err.println("* Logging is not enabled for org.ops4j.gaderian.impl.RegistryBuilder.         *");
            System.err.println("* Errors during Gaderian module descriptor parsing and validation may not be   *");
            System.err.println("* logged. This may result in difficult-to-trace runtime exceptions, if there   *");
            System.err.println("* are errors in any of your module descriptors. You should enable error        *");
            System.err.println("* logging for the org.ops4j.gaderian and gaderian loggers.                    *");
            System.err.println("********************************************************************************");
        }
    }
}

