/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.impl;

import java.lang.reflect.Constructor;
import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.events.RegistryShutdownListener;
import org.ops4j.gaderian.impl.ProxyBuilder;
import org.ops4j.gaderian.internal.ServiceModel;
import org.ops4j.gaderian.internal.ServicePoint;
import org.ops4j.gaderian.service.BodyBuilder;
import org.ops4j.gaderian.service.ClassFab;
import org.ops4j.gaderian.service.ClassFabUtils;
import org.ops4j.gaderian.service.MethodSignature;
import org.ops4j.gaderian.util.ConstructorUtils;

public final class ProxyUtils {
    public static final String SERVICE_ACCESSOR_METHOD_NAME = "_service";
    public static final String DELEGATE_ACCESSOR_METHOD_NAME = "_delegate";
    static /* synthetic */ Class class$org$ops4j$gaderian$events$RegistryShutdownListener;

    private ProxyUtils() {
    }

    public static Object createDelegatingProxy(String type, ServiceModel serviceModel, String delegationMethodName, ServicePoint servicePoint) {
        ProxyBuilder builder = new ProxyBuilder(type, servicePoint);
        ClassFab classFab = builder.getClassFab();
        ProxyUtils.addConstructor(classFab, serviceModel);
        ProxyUtils.addServiceAccessor(classFab, delegationMethodName, servicePoint);
        builder.addServiceMethods("_service()");
        Class proxyClass = classFab.createClass();
        try {
            Constructor c = proxyClass.getConstructor(serviceModel.getClass());
            return c.newInstance(serviceModel);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ex);
        }
    }

    public static RegistryShutdownListener createOuterProxy(Object delegate, ServicePoint servicePoint) {
        ProxyBuilder builder = new ProxyBuilder("OuterProxy", servicePoint, true);
        ClassFab classFab = builder.getClassFab();
        ProxyUtils.addDelegateAccessor(classFab, servicePoint, delegate);
        builder.addServiceMethods("_delegate()");
        Class proxyClass = classFab.createClass();
        try {
            return (RegistryShutdownListener)ConstructorUtils.invokeConstructor(proxyClass, new Object[]{delegate});
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ex);
        }
    }

    private static void addDelegateAccessor(ClassFab classFab, ServicePoint servicePoint, Object delegate) {
        classFab.addField("_shutdown", Boolean.TYPE);
        Class delegateClass = ClassFabUtils.getInstanceClass(classFab, delegate, servicePoint.getServiceInterface());
        classFab.addField(DELEGATE_ACCESSOR_METHOD_NAME, delegateClass);
        classFab.addConstructor(new Class[]{delegateClass}, null, "{ super(); _delegate = $1; }");
        classFab.addInterface(class$org$ops4j$gaderian$events$RegistryShutdownListener == null ? (class$org$ops4j$gaderian$events$RegistryShutdownListener = ProxyUtils.class$("org.ops4j.gaderian.events.RegistryShutdownListener")) : class$org$ops4j$gaderian$events$RegistryShutdownListener);
        if ((class$org$ops4j$gaderian$events$RegistryShutdownListener == null ? (class$org$ops4j$gaderian$events$RegistryShutdownListener = ProxyUtils.class$("org.ops4j.gaderian.events.RegistryShutdownListener")) : class$org$ops4j$gaderian$events$RegistryShutdownListener).isAssignableFrom(delegateClass)) {
            classFab.addMethod(17, new MethodSignature(Void.TYPE, "registryDidShutdown", null, null), "{ _delegate.registryDidShutdown(); _delegate = null; _shutdown = true; }");
        } else {
            classFab.addMethod(17, new MethodSignature(Void.TYPE, "registryDidShutdown", null, null), "{ _delegate = null; _shutdown = true; }");
        }
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("if (_shutdown)");
        builder.addln("  throw org.ops4j.gaderian.Gaderian#createRegistryShutdownException();");
        builder.add("return _delegate;");
        builder.end();
        classFab.addMethod(18, new MethodSignature(delegateClass, DELEGATE_ACCESSOR_METHOD_NAME, null, null), builder.toString());
    }

    private static void addConstructor(ClassFab classFab, ServiceModel model) {
        Class<?> modelClass = model.getClass();
        classFab.addField("_serviceModel", modelClass);
        classFab.addConstructor(new Class[]{modelClass}, null, "{ super(); _serviceModel = $1; }");
    }

    private static void addServiceAccessor(ClassFab classFab, String serviceModelMethodName, ServicePoint servicePoint) {
        Class serviceInterface = servicePoint.getServiceInterface();
        classFab.addField(SERVICE_ACCESSOR_METHOD_NAME, serviceInterface);
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.add("return (");
        builder.add(serviceInterface.getName());
        builder.add(") _serviceModel.");
        builder.add(serviceModelMethodName);
        builder.add("();");
        builder.end();
        classFab.addMethod(18, new MethodSignature(serviceInterface, SERVICE_ACCESSOR_METHOD_NAME, null, null), builder.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

