/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.impl;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.ops4j.gaderian.impl.AbstractMessages;
import org.ops4j.gaderian.util.Defense;

public class MessageFormatter
extends AbstractMessages {
    private final ResourceBundle _bundle;

    public MessageFormatter(ResourceBundle bundle) {
        Defense.notNull(bundle, "bundle");
        this._bundle = bundle;
    }

    public MessageFormatter(Log log, ResourceBundle bundle) {
        this(bundle);
    }

    public MessageFormatter(Class referenceClass) {
        this(referenceClass, MessageFormatter.getStringsName(referenceClass));
    }

    public MessageFormatter(Class referenceClass, String name) {
        this(MessageFormatter.getResourceBundleName(referenceClass, name));
    }

    public MessageFormatter(Log log, Class referenceClass, String name) {
        this(referenceClass, name);
    }

    public MessageFormatter(String bundleName) {
        this(ResourceBundle.getBundle(bundleName));
    }

    public MessageFormatter(Log log, String bundleName) {
        this(bundleName);
    }

    protected String findMessage(String key) {
        try {
            return this._bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    protected Locale getLocale() {
        return Locale.getDefault();
    }

    private static String getStringsName(Class referenceClass) {
        String className = referenceClass.getName();
        int lastDotIndex = className.lastIndexOf(46);
        String justClass = className.substring(lastDotIndex + 1);
        int mpos = justClass.indexOf("Messages");
        return justClass.substring(0, mpos) + "Strings";
    }

    private static String getResourceBundleName(Class referenceClass, String name) {
        int lastDotIndex;
        String packageName = null;
        packageName = referenceClass.getPackage() != null ? referenceClass.getPackage().getName() : ((lastDotIndex = referenceClass.getName().lastIndexOf(46)) == -1 ? "" : referenceClass.getName().substring(0, lastDotIndex));
        return packageName.equals("") ? name : packageName + "." + name;
    }
}

