/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.AssemblyInstruction;
import org.ops4j.gaderian.ErrorLog;
import org.ops4j.gaderian.Occurances;
import org.ops4j.gaderian.ServiceImplementationFactory;
import org.ops4j.gaderian.impl.BaseLocatable;
import org.ops4j.gaderian.impl.ImplMessages;
import org.ops4j.gaderian.impl.SchemaProcessorImpl;
import org.ops4j.gaderian.impl.ServiceImplementationFactoryParametersImpl;
import org.ops4j.gaderian.internal.Module;
import org.ops4j.gaderian.internal.ServiceImplementationConstructor;
import org.ops4j.gaderian.internal.ServicePoint;
import org.ops4j.gaderian.schema.Schema;

public final class InvokeFactoryServiceConstructor
extends BaseLocatable
implements ServiceImplementationConstructor {
    private String _factoryServiceId;
    private ServicePoint _serviceExtensionPoint;
    private Module _contributingModule;
    private List _parameters;
    private ServiceImplementationFactory _factory;
    private List _convertedFactoryParameters;
    private List _convertedAssemblyInstructions;
    static /* synthetic */ Class class$org$ops4j$gaderian$ServiceImplementationFactory;

    public Object constructCoreServiceImplementation() {
        this.setupFactoryAndParameters();
        try {
            ServiceImplementationFactoryParametersImpl factoryParameters = new ServiceImplementationFactoryParametersImpl(this._serviceExtensionPoint, this._contributingModule, this._convertedFactoryParameters);
            Object result = this._factory.createCoreServiceImplementation(factoryParameters);
            if (this._convertedAssemblyInstructions != null) {
                Iterator i = this._convertedAssemblyInstructions.iterator();
                while (i.hasNext()) {
                    AssemblyInstruction parameter = (AssemblyInstruction)i.next();
                    parameter.assemble(result, factoryParameters);
                }
            }
            return result;
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ex.getMessage(), this.getLocation(), ex);
        }
    }

    private synchronized void setupFactoryAndParameters() {
        if (this._factory == null) {
            ServicePoint factoryPoint = this._contributingModule.getServicePoint(this._factoryServiceId);
            Occurances expected = factoryPoint.getParametersCount();
            this._factory = (ServiceImplementationFactory)factoryPoint.getService(class$org$ops4j$gaderian$ServiceImplementationFactory == null ? (class$org$ops4j$gaderian$ServiceImplementationFactory = InvokeFactoryServiceConstructor.class$("org.ops4j.gaderian.ServiceImplementationFactory")) : class$org$ops4j$gaderian$ServiceImplementationFactory);
            Schema schema = factoryPoint.getParametersSchema();
            ErrorLog errorLog = this._serviceExtensionPoint.getErrorLog();
            SchemaProcessorImpl processor = new SchemaProcessorImpl(errorLog, schema);
            processor.process(this._parameters, this._contributingModule);
            this._convertedFactoryParameters = processor.getElements();
            this._convertedAssemblyInstructions = this.extractAssemblyInstructions(this._convertedFactoryParameters);
            this.checkParameterCounts(errorLog, expected);
        }
    }

    private List extractAssemblyInstructions(List parameters) {
        ArrayList result = null;
        Iterator i = parameters.iterator();
        while (i.hasNext()) {
            Object parameter = i.next();
            if (!(parameter instanceof AssemblyInstruction)) continue;
            if (result == null) {
                result = new ArrayList();
            }
            result.add(parameter);
            i.remove();
        }
        return result;
    }

    private void checkParameterCounts(ErrorLog log, Occurances expected) {
        int actual = this._convertedFactoryParameters.size();
        if (expected.inRange(actual)) {
            return;
        }
        String message = ImplMessages.wrongNumberOfParameters(this._factoryServiceId, actual, expected);
        log.error(message, this.getLocation(), null);
    }

    public Module getContributingModule() {
        return this._contributingModule;
    }

    public void setContributingModule(Module module) {
        this._contributingModule = module;
    }

    public List getParameters() {
        return this._parameters;
    }

    public ServicePoint getServiceExtensionPoint() {
        return this._serviceExtensionPoint;
    }

    public void setParameters(List list) {
        this._parameters = list;
    }

    public void setFactoryServiceId(String string) {
        this._factoryServiceId = string;
    }

    public void setServiceExtensionPoint(ServicePoint point) {
        this._serviceExtensionPoint = point;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

