/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.Occurances;
import org.ops4j.gaderian.ShutdownCoordinator;
import org.ops4j.gaderian.impl.AbstractExtensionPoint;
import org.ops4j.gaderian.impl.ElementsInnerProxyList;
import org.ops4j.gaderian.impl.ElementsInnerProxyMap;
import org.ops4j.gaderian.impl.ElementsProxyList;
import org.ops4j.gaderian.impl.ElementsProxyMap;
import org.ops4j.gaderian.impl.ImplMessages;
import org.ops4j.gaderian.impl.SchemaProcessorImpl;
import org.ops4j.gaderian.internal.ConfigurationPoint;
import org.ops4j.gaderian.internal.Contribution;
import org.ops4j.gaderian.schema.Schema;
import org.ops4j.gaderian.util.ToStringBuilder;

public final class ConfigurationPointImpl
extends AbstractExtensionPoint
implements ConfigurationPoint {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$ops4j$gaderian$impl$ConfigurationPointImpl == null ? (class$org$ops4j$gaderian$impl$ConfigurationPointImpl = ConfigurationPointImpl.class$("org.ops4j.gaderian.impl.ConfigurationPointImpl")) : class$org$ops4j$gaderian$impl$ConfigurationPointImpl));
    private List _elements;
    private List _elementsProxy;
    private Map _mappedElements;
    private Map _mappedElementsProxy;
    private boolean _canElementsBeMapped = false;
    private Occurances _expectedCount;
    private List _contributions;
    private boolean _building;
    private Schema _contributionsSchema;
    private ShutdownCoordinator _shutdownCoordinator;
    static /* synthetic */ Class class$org$ops4j$gaderian$impl$ConfigurationPointImpl;

    protected void extendDescription(ToStringBuilder builder) {
        builder.append("expectedCount", this._expectedCount);
        builder.append("contributions", this._contributions);
        builder.append("schema", this._contributionsSchema);
    }

    public int getContributionCount() {
        if (this._contributions == null) {
            return 0;
        }
        int total = 0;
        int count = this._contributions.size();
        for (int i = 0; i < count; ++i) {
            Contribution c = (Contribution)this._contributions.get(i);
            total += c.getElements().size();
        }
        return total;
    }

    public void addContribution(Contribution c) {
        if (this._contributions == null) {
            this._contributions = new ArrayList();
        }
        this._contributions.add(c);
    }

    public Occurances getExpectedCount() {
        return this._expectedCount;
    }

    public void setExpectedCount(Occurances occurances) {
        this._expectedCount = occurances;
    }

    public synchronized List getElements() {
        if (this._elements != null) {
            return this._elements;
        }
        if (this._elementsProxy == null) {
            ElementsProxyList outerProxy = new ElementsProxyList();
            new ElementsInnerProxyList(this, outerProxy);
            this._shutdownCoordinator.addRegistryShutdownListener(outerProxy);
            this._elementsProxy = outerProxy;
        }
        return this._elementsProxy;
    }

    public boolean areElementsMappable() {
        return this._canElementsBeMapped;
    }

    public synchronized Map getElementsAsMap() {
        if (!this.areElementsMappable()) {
            throw new ApplicationRuntimeException(ImplMessages.unableToMapConfiguration(this));
        }
        if (this._mappedElements != null) {
            return this._mappedElements;
        }
        if (this._mappedElementsProxy == null) {
            ElementsProxyMap outerProxy = new ElementsProxyMap();
            new ElementsInnerProxyMap(this, outerProxy);
            this._shutdownCoordinator.addRegistryShutdownListener(outerProxy);
            this._mappedElementsProxy = outerProxy;
        }
        return this._mappedElementsProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List constructElements() {
        if (this._building) {
            throw new ApplicationRuntimeException(ImplMessages.recursiveConfiguration(this.getExtensionPointId()));
        }
        try {
            if (this._elements == null) {
                this._building = true;
                this.processContributionElements();
            }
            this._elementsProxy = null;
            List list = this._elements;
            return list;
        }
        finally {
            this._building = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Map constructMapElements() {
        if (this._building) {
            throw new ApplicationRuntimeException(ImplMessages.recursiveConfiguration(this.getExtensionPointId()));
        }
        try {
            if (this._mappedElements == null) {
                this._building = true;
                this.processContributionElements();
            }
            this._mappedElementsProxy = null;
            Map map = this._mappedElements;
            return map;
        }
        finally {
            this._building = false;
        }
    }

    private void processContributionElements() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Constructing extension point " + this.getExtensionPointId()));
        }
        if (this._contributions == null) {
            this._elements = Collections.EMPTY_LIST;
            this._mappedElements = Collections.EMPTY_MAP;
            return;
        }
        SchemaProcessorImpl processor = new SchemaProcessorImpl(this.getErrorLog(), this._contributionsSchema);
        int count = this._contributions.size();
        try {
            for (int i = 0; i < count; ++i) {
                Contribution extension = (Contribution)this._contributions.get(i);
                processor.process(extension.getElements(), extension.getContributingModule());
            }
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ImplMessages.unableToConstructConfiguration(this.getExtensionPointId(), ex), ex);
        }
        if (this.areElementsMappable()) {
            this._mappedElements = Collections.unmodifiableMap(processor.getMappedElements());
        }
        this._elements = Collections.unmodifiableList(processor.getElements());
        this._contributionsSchema = null;
        this._contributions = null;
    }

    public Schema getSchema() {
        return this._contributionsSchema;
    }

    public void setContributionsSchema(Schema schema) {
        this._contributionsSchema = schema;
        this._canElementsBeMapped = this._contributionsSchema != null && this._contributionsSchema.canInstancesBeKeyed();
    }

    public Schema getContributionsSchema() {
        return this._contributionsSchema;
    }

    public void setShutdownCoordinator(ShutdownCoordinator coordinator) {
        this._shutdownCoordinator = coordinator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

