/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.gaderian;

import java.util.Collection;
import org.ops4j.gaderian.ApplicationRuntimeException;
import org.ops4j.gaderian.GaderianMessages;
import org.ops4j.gaderian.Locatable;
import org.ops4j.gaderian.Location;
import org.ops4j.gaderian.LocationHolder;

public final class Gaderian {
    public static final String THREAD_EVENT_NOTIFIER_SERVICE = "gaderian.ThreadEventNotifier";
    public static final String THREAD_LOCALE_SERVICE = "gaderian.ThreadLocale";
    public static final String INTERFACE_SYNTHESIZER_SERVICE = "gaderian.InterfaceSynthesizer";
    public static final Object INTROSPECTOR_MUTEX = new Object();

    private Gaderian() {
    }

    public static ApplicationRuntimeException createRegistryShutdownException() {
        return new ApplicationRuntimeException(GaderianMessages.registryShutdown());
    }

    public static Location findLocation(Object[] locations) {
        for (int i = 0; i < locations.length; ++i) {
            Object location = locations[i];
            Location result = Gaderian.getLocation(location);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Location getLocation(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Location) {
            return (Location)object;
        }
        if (object instanceof Locatable) {
            Locatable locatable = (Locatable)object;
            return locatable.getLocation();
        }
        return null;
    }

    public static String getLocationString(Object object) {
        Location l = Gaderian.getLocation(object);
        if (l != null) {
            return l.toString();
        }
        return GaderianMessages.unknownLocation();
    }

    public static boolean isBlank(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        return string.trim().length() == 0;
    }

    public static boolean isNonBlank(String string) {
        return !Gaderian.isBlank(string);
    }

    public static void setLocation(Object holder, Location location) {
        if (holder != null && holder instanceof LocationHolder) {
            LocationHolder lh = (LocationHolder)holder;
            lh.setLocation(location);
        }
    }

    public static boolean isEmpty(Collection c) {
        return c == null || c.isEmpty();
    }
}

