/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pidclient.business;

import java.text.MessageFormat;

public class AndsPidIdentity {
    private String appId;
    private String identifier;
    private String authDomain;

    public AndsPidIdentity() {
    }

    public AndsPidIdentity(String appId, String identifier, String authDomain) {
        this.setAppId(appId);
        this.setIdentifier(identifier);
        this.setAuthDomain(authDomain);
    }

    public String getAppId() {
        return this.escape(this.appId);
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getIdentifier() {
        return this.escape(this.identifier);
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getAuthDomain() {
        return this.escape(this.authDomain);
    }

    public void setAuthDomain(String authDomain) {
        this.authDomain = authDomain;
    }

    public String toXML(String methodName) {
        return MessageFormat.format("<request name=\"{0}\"><properties><property name=\"appId\" value=\"" + this.getAppId() + "\"/>" + "<property name=\"identifier\" value=\"" + this.getIdentifier() + "\"/>" + "<property name=\"authDomain\" value=\"" + this.getAuthDomain() + "\"/>" + "</properties>" + "</request>", methodName);
    }

    public String toString() {
        return "RequestorIdentity [appId=" + this.appId + ", authDomain=" + this.authDomain + ", identifier=" + this.identifier + "]";
    }

    public String escape(String in) {
        if (in == null) {
            return in;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '<') {
                buffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                buffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                buffer.append("&amp;");
                continue;
            }
            if (c == '\"') {
                buffer.append("&quot;");
                continue;
            }
            if (c == '\'') {
                buffer.append("&apos;");
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

