/**
 * Copyright 2010, CSIRO Australia.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * 
 */
package au.csiro.pidclient;

import java.util.List;

import au.csiro.pidclient.business.AndsPidResponseProperty;

/**
 * Represents an ANDS Persistent Identifier service response.
 * 
 * Copyright 2010, CSIRO Australia All rights reserved.
 * 
 * @author Robert Bridle on 08/02/2010
 * @version $Revision: 7131 $ $Date: 2010-06-09 14:25:15 +1000 (Wed, 09 Jun 2010) $
 */
public class AndsPidResponse
{
    /**
     * A constant that represents the case where no handle is returned.
     */
    public static final String NO_HANDLE_FOUND = "No handle found";

    /**
     * The formatted XML response from the ANDS Persistent Identifier service.
     */
    private String xmlResponse;

    /**
     * Whether an ANDS Persistent Identifier service call was successful.
     */
    private boolean success;

    /**
     * The ANDS Persistent Identifier service call return message.
     */
    private String message;    
    
    /**
     * The handles returned by an ANDS PID service call.
     */
    private List<String> handles;

    /**
     * The properties associated with the handle after the ANDS Persistent Identifier service call.
     */
    private List<AndsPidResponseProperty> properties;

    /**
     *
     */
    public AndsPidResponse()
    {
    }

    /**
     * @return the xmlResponse
     */
    public String getXmlResponse()
    {
        return xmlResponse;
    }

    /**
     * @param xmlResponse
     *            the xmlResponse to set
     */
    public void setXmlResponse(String xmlResponse)
    {
        this.xmlResponse = xmlResponse;
    }

    /**
     * @return the web service response message
     */
    public String getMessage()
    {
        return message;
    }

    /**
     * @param message
     *            the web service response message to set
     */
    public void setMessage(String message)
    {
        this.message = message;
    }
    
    /**
     * @return the success
     */
    public boolean isSuccess()
    {
        return success;
    }

    /**
     * @param success
     *            the success to set
     */
    public void setSuccess(boolean success)
    {
        this.success = success;
    }

    /**
     * @return the handle which an ANDS PID service call mints or modifies, if no handle is found then {@link
     *         #NO_HANDLE_FOUND} is returned.
     */
    public String getHandle()
    {
        for(String handle : this.getHandles())
        {
            // return the first element in this list in proper sequence.
            return handle;
        }
        return AndsPidResponse.NO_HANDLE_FOUND;
    }
    
    /**
     * @return the handles
     */
    public List<String> getHandles()
    {
        return handles;
    }

    /**
     * @param handles the handles to set
     */
    public void setHandles(List<String> handles)
    {
        this.handles = handles;
    }

    /**
     * @return the properties
     */
    public List<AndsPidResponseProperty> getProperties()
    {
        return properties;
    }

    /**
     * @param properties
     *            the properties to set
     */
    public void setProperties(List<AndsPidResponseProperty> properties)
    {
        this.properties = properties;
    }
}
