/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pidclient;

import au.csiro.pidclient.AndsPidResponse;
import au.csiro.pidclient.business.AndsPidIdentity;
import au.csiro.pidclient.business.AndsPidResponseProperty;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndsPidClient {
    private static final int TRIPLE = 3;
    private static final Logger LOG = Logger.getLogger((String)AndsPidClient.class.getName());
    private static final String PROPERTIES_FILENAME = "/ands-pid-client.properties";
    private static String applicationName;
    private static String mintMethodName;
    private static String addValueMethodName;
    private static String addValueByIndexMethodName;
    private static String modifyValueByIndexMethodName;
    private static String deleteValueByIndexMethodName;
    private static String listHandlesMethodName;
    private static String getHandleMethodName;
    private AndsPidIdentity requestorIdentity;
    private String pidServiceHost;
    private int pidServicePort;
    private String pidServicePath;

    private static void loadProperties() {
        InputStream is = AndsPidResponse.class.getResourceAsStream(PROPERTIES_FILENAME);
        Properties props = new Properties();
        try {
            props.load(is);
            applicationName = props.getProperty("application.name");
            mintMethodName = props.getProperty("method.mint");
            addValueMethodName = props.getProperty("method.addValue");
            addValueByIndexMethodName = props.getProperty("method.addValueByIndex");
            modifyValueByIndexMethodName = props.getProperty("method.modifyValueByIndex");
            deleteValueByIndexMethodName = props.getProperty("method.deleteValueByIndex");
            listHandlesMethodName = props.getProperty("method.listHandles");
            getHandleMethodName = props.getProperty("method.getHandle");
        }
        catch (IOException e) {
            LOG.error((Object)"Could not load properties file: /ands-pid-client.properties", (Throwable)e);
        }
    }

    public AndsPidClient() {
        this(null, 0, null, null, null, null);
    }

    public AndsPidClient(String pidServiceHost, int pidServicePort, String pidServicePath, String appId, String identifier, String authDomain) {
        this(pidServiceHost, pidServicePort, pidServicePath, new AndsPidIdentity(appId, identifier, authDomain));
    }

    public AndsPidClient(String pidServiceHost, int pidServicePort, String pidServicePath, AndsPidIdentity requestorIdentity) {
        this.setPidServiceHost(pidServiceHost);
        this.setPidServicePort(pidServicePort);
        this.setPidServicePath(pidServicePath);
        this.setRequestorIdentity(requestorIdentity);
        AndsPidClient.loadProperties();
    }

    public String mintHandle(HandleType type, String value) throws IllegalStateException, IllegalArgumentException, HttpException, IOException {
        this.validateState();
        this.validateMintHandleArguments(type, value);
        String queryString = MessageFormat.format("type={0}&value={1}", type.value(), value);
        return this.executeMethod(queryString, mintMethodName);
    }

    public AndsPidResponse mintHandleFormattedResponse(HandleType type, String value) throws IllegalStateException, IllegalArgumentException, HttpException, IOException, XPathExpressionException, ParserConfigurationException, SAXException {
        return this.populateAndsPidResponse(this.mintHandle(type, value));
    }

    public String mintHandle(HandleType type, int index, String value) throws IllegalStateException, IllegalArgumentException, HttpException, IOException {
        this.validateState();
        this.validateMintHandleArguments(type, value);
        String queryString = MessageFormat.format("type={0}&index={1}&value={2}", type.value(), index, value);
        return this.executeMethod(queryString, mintMethodName);
    }

    public AndsPidResponse mintHandleFormattedResponse(HandleType type, int index, String value) throws IllegalStateException, IllegalArgumentException, HttpException, IOException, XPathExpressionException, ParserConfigurationException, SAXException {
        return this.populateAndsPidResponse(this.mintHandle(type, index, value));
    }

    public String addValue(String handle, HandleType type, String value) throws IllegalStateException, IllegalArgumentException, HttpException, IOException {
        this.validateState();
        if (StringUtils.isEmpty((String)handle) || StringUtils.isEmpty((String)value) || type == null || type.equals((Object)HandleType.EMPTY)) {
            throw new IllegalArgumentException(MessageFormat.format("The method addValue() can not be called with null or empty arguments:\n type= {0}\n value= {1}\n", type == null ? null : type.value(), value));
        }
        String queryString = MessageFormat.format("handle={0}&type={1}&value={2}", handle, type.value(), value);
        return this.executeMethod(queryString, addValueMethodName);
    }

    public AndsPidResponse addValueFormattedResponse(String handle, HandleType type, String value) throws IllegalStateException, IllegalArgumentException, HttpException, IOException, XPathExpressionException, ParserConfigurationException, SAXException {
        return this.populateAndsPidResponse(this.addValue(handle, type, value));
    }

    public String addValueByIndex(String handle, int index, HandleType type, String value) throws IllegalStateException, IllegalArgumentException, HttpException, IOException {
        this.validateState();
        if (StringUtils.isEmpty((String)handle) || StringUtils.isEmpty((String)value) || type == null || type.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format("The method addValueByIndex() can not be called with null or empty arguments:\n type= {0}\n value= {1}\n", type == null ? null : type.value(), value));
        }
        String queryString = MessageFormat.format("handle={0}&index={1}&type={2}&value={3}", handle, Integer.toString(index), type.value(), value);
        return this.executeMethod(queryString, addValueByIndexMethodName);
    }

    public AndsPidResponse addValueByIndexFormattedResponse(String handle, int index, HandleType type, String value) throws IllegalStateException, IllegalArgumentException, HttpException, IOException, XPathExpressionException, ParserConfigurationException, SAXException {
        return this.populateAndsPidResponse(this.addValueByIndex(handle, index, type, value));
    }

    public String modifyValueByIndex(String handle, int index, String newValue) throws IllegalStateException, IllegalArgumentException, HttpException, IOException {
        this.validateState();
        if (StringUtils.isEmpty((String)handle) || StringUtils.isEmpty((String)newValue)) {
            throw new IllegalArgumentException(MessageFormat.format("The method modifyValueByIndex() can not be called with null or empty arguments:\n handle={0}\n newValue={1}\n", handle, newValue));
        }
        String queryString = MessageFormat.format("handle={0}&index={1}&value={2}", handle, Integer.toString(index), newValue);
        return this.executeMethod(queryString, modifyValueByIndexMethodName);
    }

    public AndsPidResponse modifyValueByIndexFormattedResponse(String handle, int index, String newValue) throws IllegalStateException, IllegalArgumentException, HttpException, IOException, XPathExpressionException, ParserConfigurationException, SAXException {
        return this.populateAndsPidResponse(this.modifyValueByIndex(handle, index, newValue));
    }

    public String deleteValueByIndex(String handle, int index) throws IllegalStateException, IllegalArgumentException, HttpException, IOException {
        this.validateState();
        if (StringUtils.isEmpty((String)handle)) {
            throw new IllegalArgumentException(MessageFormat.format("The method deleteValueByIndex() can not be called with null or empty arguments:\n handle={0}\n", handle));
        }
        String queryString = MessageFormat.format("handle={0}&index={1}", handle, Integer.toString(index));
        return this.executeMethod(queryString, deleteValueByIndexMethodName);
    }

    public AndsPidResponse deleteValueByIndexFormattedResponse(String handle, int index) throws IllegalStateException, IllegalArgumentException, HttpException, IOException, XPathExpressionException, ParserConfigurationException, SAXException {
        return this.populateAndsPidResponse(this.deleteValueByIndex(handle, index));
    }

    public String listHandles() throws IllegalStateException, HttpException, IOException {
        this.validateState();
        return this.executeMethod("", listHandlesMethodName);
    }

    public AndsPidResponse listHandlesFormattedResponse() throws IllegalStateException, HttpException, IOException, XPathExpressionException, ParserConfigurationException, SAXException {
        return this.populateAndsPidResponse(this.listHandles());
    }

    public String getHandle(String handle) throws IllegalStateException, IllegalArgumentException, HttpException, IOException {
        this.validateState();
        if (StringUtils.isEmpty((String)handle)) {
            throw new IllegalArgumentException(MessageFormat.format("The method getHandle() can not be called with null or empty arguments:\n handle={0}\n", handle));
        }
        String queryString = MessageFormat.format("handle={0}", handle);
        return this.executeMethod(queryString, getHandleMethodName);
    }

    public AndsPidResponse getHandleFormattedResponse(String handle) throws IllegalStateException, IllegalArgumentException, HttpException, IOException, XPathExpressionException, ParserConfigurationException, SAXException {
        return this.populateAndsPidResponse(this.getHandle(handle));
    }

    private String executeMethod(String queryString, String methodName) throws HttpException, IOException {
        HttpsURL url = new HttpsURL("", "", this.getPidServiceHost(), this.getPidServicePort(), this.getPidServicePath(), queryString);
        if ("/".equals(url.getPath())) {
            url.setPath(url.getPath() + methodName);
        } else {
            url.setPath(url.getPath() + "/" + methodName);
        }
        String identityXML = this.getRequestorIdentity().toXML(methodName);
        return this.executePostMethod(url.toString(), identityXML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executePostMethod(String postMethodURL, String identityXML) throws HttpException, IOException {
        LOG.debug((Object)("Post method URL: " + postMethodURL));
        LOG.debug((Object)("Identity XML: " + identityXML));
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.useragent", (Object)applicationName);
        client.getParams().setParameter("Content-Type", (Object)"text/xml");
        client.getParams().setParameter("Content-Encoding", (Object)"UTF-8");
        PostMethod method = new PostMethod(postMethodURL);
        BufferedReader br = null;
        StringBuffer strBuf = new StringBuffer();
        try {
            StringRequestEntity entity = new StringRequestEntity(identityXML, "text/xml", "UTF-8");
            client.getParams().setParameter("Content-Length", (Object)entity.getContentLength());
            method.setRequestEntity((RequestEntity)entity);
            int returnCode = client.executeMethod((HttpMethod)method);
            if (returnCode == 501) {
                LOG.error((Object)"The post method is not implemented by this URI");
                method.getResponseBodyAsString();
            } else {
                String readLine;
                br = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream()));
                while ((readLine = br.readLine()) != null) {
                    LOG.debug((Object)readLine);
                    strBuf.append(readLine);
                }
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            method.releaseConnection();
        }
        return strBuf.toString();
    }

    private boolean parseForSuccess(Document doc) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expr = xpath.compile("//response[@type]");
        Object result = expr.evaluate(doc, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        for (int i = 0; i < nodes.getLength(); ++i) {
            int j = 0;
            if (j >= nodes.item(i).getAttributes().getLength()) continue;
            Node node = nodes.item(i).getAttributes().item(j);
            return "success".equals(node.getNodeValue());
        }
        return false;
    }

    private String parseForMessage(Document doc) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        int i = 0;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expr = xpath.compile("//response/message");
        Object result = expr.evaluate(doc, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        if (i < nodes.getLength()) {
            return nodes.item(i).getTextContent();
        }
        return null;
    }

    private List<String> parseForHandles(Document doc) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        ArrayList<String> handles = new ArrayList<String>();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expr = xpath.compile("//identifier[@handle]");
        Object result = expr.evaluate(doc, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        for (int i = 0; i < nodes.getLength(); ++i) {
            for (int j = 0; j < nodes.item(i).getAttributes().getLength(); ++j) {
                Node node = nodes.item(i).getAttributes().item(j);
                String handle = node.getNodeValue();
                handles.add(handle);
            }
        }
        return handles;
    }

    private static List<AndsPidResponseProperty> parseForProperties(Document doc) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        ArrayList<AndsPidResponseProperty> properties = new ArrayList<AndsPidResponseProperty>();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expr = xpath.compile("//property[@index]");
        Object result = expr.evaluate(doc, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        for (int i = 0; i < nodes.getLength(); ++i) {
            String[] triple = new String[3];
            for (int j = 0; j < Math.min(3, nodes.item(i).getAttributes().getLength()); ++j) {
                Node node = nodes.item(i).getAttributes().item(j);
                triple[j] = node.getNodeValue();
            }
            properties.add(new AndsPidResponseProperty(Integer.valueOf(triple[0]), triple[1], triple[2]));
        }
        return properties;
    }

    private static Document parseXML(String xmlResponse) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        StringReader reader = new StringReader(xmlResponse);
        InputSource inputSource = new InputSource(reader);
        Document doc = builder.parse(inputSource);
        reader.close();
        return doc;
    }

    private AndsPidResponse populateAndsPidResponse(String xmlResponse) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        AndsPidResponse response = new AndsPidResponse();
        response.setXmlResponse(xmlResponse);
        Document doc = AndsPidClient.parseXML(xmlResponse);
        response.setMessage(this.parseForMessage(doc));
        response.setSuccess(this.parseForSuccess(doc));
        response.setHandles(this.parseForHandles(doc));
        response.setProperties(AndsPidClient.parseForProperties(doc));
        return response;
    }

    private void validateState() throws IllegalStateException {
        StringBuffer errorMsg = new StringBuffer();
        if (StringUtils.isEmpty((String)this.getPidServiceHost())) {
            errorMsg.append("The host name of the ANDS PID service has not been provided. e.g. test.org.au\n");
        }
        if (this.getRequestorIdentity() == null || StringUtils.isEmpty((String)this.getRequestorIdentity().getAppId())) {
            errorMsg.append("The appID of the caller has not been provided. e.g. unique Id provided by ANDS upon IP registration.\n");
        }
        if (this.getRequestorIdentity() == null || StringUtils.isEmpty((String)this.getRequestorIdentity().getIdentifier())) {
            errorMsg.append("The identifier of the caller has not been provided. e.g. identifier or name of the repository calling the service.\n");
        }
        if (this.getRequestorIdentity() == null || StringUtils.isEmpty((String)this.getRequestorIdentity().getAuthDomain())) {
            errorMsg.append("The authDomain of the caller has not been provided. e.g. the domain of the organisation calling the service.");
        }
        if (errorMsg.length() != 0) {
            throw new IllegalStateException(errorMsg.toString());
        }
    }

    private void validateMintHandleArguments(HandleType type, String value) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("The method mintHandle() can not be called with a null HandleType argument.\n");
        }
        if (type.isEmpty() != StringUtils.isEmpty((String)value)) {
            throw new IllegalArgumentException(MessageFormat.format("The method mintHandle() can only be called if both arguments are empty or both arguments are not empty:\n type= {0}\n value={1}\n", type == null ? null : type.value(), value));
        }
    }

    public String getPidServiceHost() {
        return this.pidServiceHost;
    }

    public void setPidServiceHost(String pidServiceHost) {
        this.pidServiceHost = pidServiceHost;
    }

    public int getPidServicePort() {
        return this.pidServicePort;
    }

    public void setPidServicePort(int pidServicePort) {
        this.pidServicePort = pidServicePort;
    }

    public String getPidServicePath() {
        return this.pidServicePath;
    }

    public void setPidServicePath(String pidServicePath) {
        this.pidServicePath = pidServicePath;
    }

    public AndsPidIdentity getRequestorIdentity() {
        return this.requestorIdentity;
    }

    public void setRequestorIdentity(AndsPidIdentity requestorIdentity) {
        this.requestorIdentity = requestorIdentity;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HandleType {
        EMPTY(""),
        URL("URL"),
        DESC("DESC");

        private final String value;

        private HandleType(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public boolean isEmpty() {
            return EMPTY.value().equals(this.value);
        }
    }
}

