/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.kafka.config.streams;

import java.nio.file.Path;
import java.time.Duration;
import net.soundvibe.kafka.config.AbstractConfigBuilder;
import net.soundvibe.kafka.config.streams.ProcessingGuarantee;
import net.soundvibe.kafka.config.streams.TopologyOptimization;
import net.soundvibe.kafka.config.streams.UpgradeFrom;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.errors.DeserializationExceptionHandler;
import org.apache.kafka.streams.errors.ProductionExceptionHandler;
import org.apache.kafka.streams.processor.PartitionGrouper;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.state.RocksDBConfigSetter;

public final class StreamsConfigBuilder
extends AbstractConfigBuilder<StreamsConfigBuilder> {
    private StreamsConfigBuilder() {
    }

    public static StreamsConfigBuilder create() {
        return new StreamsConfigBuilder();
    }

    public StreamsConfigBuilder withApplicationId(String applicationId) {
        this.props.put("application.id", applicationId);
        return this;
    }

    public StreamsConfigBuilder withReplicationFactor(int replicationFactor) {
        this.props.put("replication.factor", replicationFactor);
        return this;
    }

    public StreamsConfigBuilder withStateDir(Path stateDir) {
        this.props.put("state.dir", stateDir.toString());
        return this;
    }

    public StreamsConfigBuilder withCacheMaxBytesBuffering(long cacheMaxBytesBuffering) {
        this.props.put("cache.max.bytes.buffering", cacheMaxBytesBuffering);
        return this;
    }

    @Override
    public StreamsConfigBuilder withClientId(String clientId) {
        return (StreamsConfigBuilder)super.withClientId(clientId);
    }

    public StreamsConfigBuilder withDefaultDeserializationExceptionHandler(Class<? extends DeserializationExceptionHandler> defaultDeserializationExceptionHandler) {
        this.props.put("default.deserialization.exception.handler", defaultDeserializationExceptionHandler);
        return this;
    }

    public StreamsConfigBuilder withDefaultKeySerde(Class<? extends Serde> defaultKeySerde) {
        this.props.put("default.key.serde", defaultKeySerde);
        return this;
    }

    public StreamsConfigBuilder withDefaultValueSerde(Class<? extends Serde> defaultValueSerde) {
        this.props.put("default.value.serde", defaultValueSerde);
        return this;
    }

    public StreamsConfigBuilder withDefaultProductionExceptionHandler(Class<? extends ProductionExceptionHandler> defaultProductionExceptionHandler) {
        this.props.put("default.production.exception.handler", defaultProductionExceptionHandler);
        return this;
    }

    public StreamsConfigBuilder withDefaultTimestampExtractor(Class<? extends TimestampExtractor> defaultTimestampExtractor) {
        this.props.put("default.timestamp.extractor", defaultTimestampExtractor);
        return this;
    }

    public StreamsConfigBuilder withNumStandbyReplicas(int numStandbyReplicas) {
        this.props.put("num.standby.replicas", numStandbyReplicas);
        return this;
    }

    public StreamsConfigBuilder withNumStreamThreads(int numStreamThreads) {
        this.props.put("num.stream.threads", numStreamThreads);
        return this;
    }

    public StreamsConfigBuilder withMaxTaskIdle(Duration maxTaskIdle) {
        this.props.put("max.task.idle.ms", maxTaskIdle.toMillis());
        return this;
    }

    public StreamsConfigBuilder withProcessingGuarantee(ProcessingGuarantee processingGuarantee) {
        this.props.put("processing.guarantee", processingGuarantee.name);
        return this;
    }

    public StreamsConfigBuilder withTopologyOptimization(TopologyOptimization topologyOptimization) {
        this.props.put("topology.optimization", topologyOptimization.name);
        return this;
    }

    public StreamsConfigBuilder withApplicationServer(String applicationServer) {
        this.props.put("application.server", applicationServer);
        return this;
    }

    public StreamsConfigBuilder withBufferedRecordsPerPartition(int bufferedRecordsPerPartition) {
        this.props.put("buffered.records.per.partition", bufferedRecordsPerPartition);
        return this;
    }

    public StreamsConfigBuilder withCommitInterval(Duration commitInterval) {
        this.props.put("commit.interval.ms", commitInterval.toMillis());
        return this;
    }

    @Deprecated
    public StreamsConfigBuilder withPartitionGrouper(Class<? extends PartitionGrouper> partitionGrouper) {
        this.props.put("partition.grouper", partitionGrouper);
        return this;
    }

    public StreamsConfigBuilder withPoll(Duration poll) {
        this.props.put("poll.ms", poll.toMillis());
        return this;
    }

    public StreamsConfigBuilder withRocksDBConfigSetter(Class<? extends RocksDBConfigSetter> rocksDBConfigSetter) {
        this.props.put("rocksdb.config.setter", rocksDBConfigSetter);
        return this;
    }

    public StreamsConfigBuilder withStateCleanupDelay(Duration stateCleanupDelay) {
        this.props.put("state.cleanup.delay.ms", stateCleanupDelay.toMillis());
        return this;
    }

    public StreamsConfigBuilder withUpgradeFrom(UpgradeFrom upgradeFrom) {
        this.props.put("upgrade.from", upgradeFrom == null ? upgradeFrom : upgradeFrom.version);
        return this;
    }

    public StreamsConfigBuilder withWindowStoreChangeLogAdditionalRetention(Duration windowStoreChangeLogAdditionalRetention) {
        this.props.put("windowstore.changelog.additional.retention.ms", windowStoreChangeLogAdditionalRetention.toMillis());
        return this;
    }
}

