/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.kafka.config.producer;

import java.time.Duration;
import java.util.Arrays;
import net.soundvibe.kafka.config.AbstractConfigBuilder;
import net.soundvibe.kafka.config.producer.Acks;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.serialization.Serializer;

public final class ProducerConfigBuilder
extends AbstractConfigBuilder<ProducerConfigBuilder> {
    private ProducerConfigBuilder() {
    }

    public static ProducerConfigBuilder create() {
        return new ProducerConfigBuilder();
    }

    public ProducerConfigBuilder withBatchSize(int batchSize) {
        this.props.put("batch.size", batchSize);
        return this;
    }

    public ProducerConfigBuilder withAcks(Acks acks) {
        this.props.put("acks", acks.name);
        return this;
    }

    public ProducerConfigBuilder withLinger(Duration linger) {
        this.props.put("linger.ms", linger.toMillis());
        return this;
    }

    @Override
    public ProducerConfigBuilder withRequestTimeout(Duration requestTimeout) {
        return (ProducerConfigBuilder)super.withRequestTimeout(requestTimeout);
    }

    public ProducerConfigBuilder withDeliveryTimeout(Duration deliveryTimeout) {
        this.props.put("delivery.timeout.ms", (int)deliveryTimeout.toMillis());
        return this;
    }

    public ProducerConfigBuilder withMaxRequestSize(int maxRequestSize) {
        this.props.put("max.request.size", maxRequestSize);
        return this;
    }

    public ProducerConfigBuilder withMaxBlock(Duration maxBlock) {
        this.props.put("max.block.ms", maxBlock.toMillis());
        return this;
    }

    public ProducerConfigBuilder withBufferMemory(long bufferMemory) {
        this.props.put("buffer.memory", bufferMemory);
        return this;
    }

    public ProducerConfigBuilder withCompressionType(CompressionType compressionType) {
        this.props.put("compression.type", compressionType.name);
        return this;
    }

    public ProducerConfigBuilder withMaxInFlightRequestsPerConnection(int maxInFlightRequestsPerConnection) {
        this.props.put("max.in.flight.requests.per.connection", maxInFlightRequestsPerConnection);
        return this;
    }

    public ProducerConfigBuilder withRetries(int retries) {
        this.props.put("retries", retries);
        return this;
    }

    public ProducerConfigBuilder withPartitioner(Class<? extends Partitioner> partitioner) {
        this.props.put("partitioner.class", partitioner);
        return this;
    }

    public ProducerConfigBuilder withEnableIdempotence(boolean enableIdempotence) {
        this.props.put("enable.idempotence", enableIdempotence);
        return this;
    }

    public ProducerConfigBuilder withTransactionTimeout(Duration transactionTimeout) {
        this.props.put("transaction.timeout.ms", (int)transactionTimeout.toMillis());
        return this;
    }

    public ProducerConfigBuilder withTransactionalId(String transactionalId) {
        this.props.put("transactional.id", transactionalId);
        return this;
    }

    public ProducerConfigBuilder withKeySerializer(Class<? extends Serializer> keySerializer) {
        this.props.put("key.serializer", keySerializer);
        return this;
    }

    public ProducerConfigBuilder withValueSerializer(Class<? extends Serializer> valueSerializer) {
        this.props.put("value.serializer", valueSerializer);
        return this;
    }

    @SafeVarargs
    public final ProducerConfigBuilder withInterceptorClasses(Class<? extends ProducerInterceptor> ... interceptorClasses) {
        this.props.put("interceptor.classes", Arrays.asList(interceptorClasses));
        return this;
    }
}

