/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.kafka.config;

import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import net.soundvibe.kafka.config.ConfigBuilder;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.auth.SecurityProviderCreator;

public class AbstractConfigBuilder<T extends AbstractConfigBuilder<T>>
implements ConfigBuilder {
    protected final Map<String, Object> props = new LinkedHashMap<String, Object>();

    public T withBootstrapServers(String bootstrapServers) {
        this.props.put("bootstrap.servers", bootstrapServers);
        return (T)this;
    }

    public T withBootstrapServers(List<String> bootstrapServers) {
        return this.withBootstrapServers(String.join((CharSequence)",", bootstrapServers));
    }

    public T withClientId(String clientId) {
        this.props.put("client.id", clientId);
        return (T)this;
    }

    public T withClientRack(String clientRack) {
        this.props.put("client.rack", clientRack);
        return (T)this;
    }

    public T withClientDNSLookup(ClientDnsLookup clientDNSLookup) {
        this.props.put("client.dns.lookup", clientDNSLookup.toString());
        return (T)this;
    }

    public T withMetadataMaxAge(Duration metadataMaxAge) {
        this.props.put("metadata.max.age.ms", (int)metadataMaxAge.toMillis());
        return (T)this;
    }

    public T withSendBufferBytes(int sendBufferBytes) {
        this.props.put("send.buffer.bytes", sendBufferBytes);
        return (T)this;
    }

    public T withReceiveBufferBytes(int receiveBufferBytes) {
        this.props.put("receive.buffer.bytes", receiveBufferBytes);
        return (T)this;
    }

    public T withReconnectBackoff(Duration reconnectBackoff) {
        this.props.put("reconnect.backoff.ms", reconnectBackoff.toMillis());
        return (T)this;
    }

    public T withReconnectBackoffMax(Duration reconnectBackoffMax) {
        this.props.put("reconnect.backoff.max.ms", reconnectBackoffMax.toMillis());
        return (T)this;
    }

    public T withRetryBackoff(Duration retryBackoff) {
        this.props.put("retry.backoff.ms", retryBackoff.toMillis());
        return (T)this;
    }

    public T withMetricsSampleWindow(Duration metricsSampleWindow) {
        this.props.put("metrics.sample.window.ms", metricsSampleWindow.toMillis());
        return (T)this;
    }

    public T withMetricsNumSamples(int metricsNumSamples) {
        this.props.put("metrics.num.samples", metricsNumSamples);
        return (T)this;
    }

    public T withMetricsRecordingLevel(Sensor.RecordingLevel metricsRecordingLevel) {
        this.props.put("metrics.recording.level", metricsRecordingLevel.name);
        return (T)this;
    }

    public T withMetricReporterClasses(Class<?> ... metricReporterClasses) {
        this.props.put("metric.reporters", Arrays.asList(metricReporterClasses));
        return (T)this;
    }

    public T withConnectionsMaxIdle(Duration connectionsMaxIdle) {
        this.props.put("connections.max.idle.ms", connectionsMaxIdle.toMillis());
        return (T)this;
    }

    public T withRequestTimeout(Duration requestTimeout) {
        this.props.put("request.timeout.ms", (int)requestTimeout.toMillis());
        return (T)this;
    }

    public T withSecurityProtocol(SecurityProtocol securityProtocol) {
        this.props.put("security.protocol", securityProtocol.name);
        return (T)this;
    }

    public T withSaslMechanism(String saslMechanism) {
        this.props.put("sasl.mechanism", saslMechanism);
        return (T)this;
    }

    @SafeVarargs
    public final T withSecurityProviders(Class<? extends SecurityProviderCreator> ... securityProviders) {
        this.props.put("security.providers", Arrays.stream(securityProviders).map(Class::getName).collect(Collectors.joining(",")));
        return (T)this;
    }

    public T withCustom(String name, Object value) {
        this.props.put(name, value);
        return (T)this;
    }

    public T withCustomMap(Map<String, Object> propertyMap) {
        this.props.putAll(propertyMap);
        return (T)this;
    }

    @Override
    public Properties buildProperties() {
        Properties properties = new Properties();
        this.props.entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> properties.put(e.getKey(), e.getValue()));
        return properties;
    }

    @Override
    public Map<String, Object> buildMap() {
        return new LinkedHashMap<String, Object>(this.props);
    }
}

