/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.kafka.config.consumer;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import net.soundvibe.kafka.config.AbstractConfigBuilder;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.serialization.Deserializer;

public final class ConsumerConfigBuilder
extends AbstractConfigBuilder<ConsumerConfigBuilder> {
    private ConsumerConfigBuilder() {
    }

    public static ConsumerConfigBuilder create() {
        return new ConsumerConfigBuilder();
    }

    public ConsumerConfigBuilder withGroupId(String groupId) {
        this.props.put("group.id", groupId);
        return this;
    }

    public ConsumerConfigBuilder withGroupInstanceId(String groupInstanceId) {
        this.props.put("group.instance.id", groupInstanceId);
        return this;
    }

    public ConsumerConfigBuilder withMaxPollRecords(int maxPollRecords) {
        this.props.put("max.poll.records", maxPollRecords);
        return this;
    }

    public ConsumerConfigBuilder withMaxPollInterval(Duration maxPollInterval) {
        this.props.put("max.poll.interval.ms", (int)maxPollInterval.toMillis());
        return this;
    }

    public ConsumerConfigBuilder withSessionTimeout(Duration sessionTimeout) {
        this.props.put("session.timeout.ms", (int)sessionTimeout.toMillis());
        return this;
    }

    public ConsumerConfigBuilder withHeartbeatInterval(Duration heartbeatInterval) {
        this.props.put("heartbeat.interval.ms", (int)heartbeatInterval.toMillis());
        return this;
    }

    public ConsumerConfigBuilder withEnableAutoCommit(boolean enableAutoCommit) {
        this.props.put("enable.auto.commit", enableAutoCommit);
        return this;
    }

    public ConsumerConfigBuilder withAutoCommitInterval(Duration autoCommitInterval) {
        this.props.put("auto.commit.interval.ms", (int)autoCommitInterval.toMillis());
        return this;
    }

    public ConsumerConfigBuilder withPartitionAssignmentStrategy(Class<? extends PartitionAssignor> partitionAssignmentStrategy) {
        this.props.put("partition.assignment.strategy", Collections.singletonList(partitionAssignmentStrategy));
        return this;
    }

    public ConsumerConfigBuilder withAutoOffsetReset(OffsetResetStrategy autoOffsetReset) {
        this.props.put("auto.offset.reset", autoOffsetReset.name().toLowerCase(Locale.ROOT));
        return this;
    }

    public ConsumerConfigBuilder withFetchMinBytes(int fetchMinBytes) {
        this.props.put("fetch.min.bytes", fetchMinBytes);
        return this;
    }

    public ConsumerConfigBuilder withFetchMaxBytes(int fetchMaxBytes) {
        this.props.put("fetch.max.bytes", fetchMaxBytes);
        return this;
    }

    public ConsumerConfigBuilder withFetchMaxWait(Duration fetchMaxWait) {
        this.props.put("fetch.max.wait.ms", (int)fetchMaxWait.toMillis());
        return this;
    }

    public ConsumerConfigBuilder withMaxPartitionFetchBytes(int maxPartitionFetchBytes) {
        this.props.put("max.partition.fetch.bytes", maxPartitionFetchBytes);
        return this;
    }

    public ConsumerConfigBuilder withCheckCRCs(boolean checkCRCs) {
        this.props.put("check.crcs", checkCRCs);
        return this;
    }

    public ConsumerConfigBuilder withKeyDeserializer(Deserializer<?> keyDeserializer) {
        this.props.put("key.deserializer", keyDeserializer);
        return this;
    }

    public ConsumerConfigBuilder withValueDeserializer(Deserializer<?> valueDeserializer) {
        this.props.put("value.deserializer", valueDeserializer);
        return this;
    }

    public ConsumerConfigBuilder withDefaultApiTimeout(Duration defaultApiTimeout) {
        this.props.put("default.api.timeout.ms", (int)defaultApiTimeout.toMillis());
        return this;
    }

    @SafeVarargs
    public final ConsumerConfigBuilder withInterceptorClasses(Class<? extends ConsumerInterceptor> ... interceptorClasses) {
        this.props.put("interceptor.classes", Arrays.asList(interceptorClasses));
        return this;
    }

    public ConsumerConfigBuilder withExcludeInternalTopics(boolean excludeInternalTopics) {
        this.props.put("exclude.internal.topics", excludeInternalTopics);
        return this;
    }

    public ConsumerConfigBuilder withIsolationLevel(IsolationLevel isolationLevel) {
        this.props.put("isolation.level", isolationLevel.toString().toLowerCase(Locale.ROOT));
        return this;
    }

    public ConsumerConfigBuilder withAllowAutoCreateTopics(boolean allowAutoCreateTopics) {
        this.props.put("allow.auto.create.topics", allowAutoCreateTopics);
        return this;
    }
}

