/*
 * Decompiled with CFR 0.152.
 */
package net.snemeis;

import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.RawString;
import java.util.Objects;
import java.util.stream.Collectors;

public class HtmlNamespace {
    public static NamespaceResolver htmlNamespaceResolver() {
        return NamespaceResolver.builder((String)"html").resolve(ctx -> {
            if (ctx.getName().equals("attr")) {
                return HtmlNamespace.htmlAttr(ctx);
            }
            if (ctx.getName().equals("class")) {
                return HtmlNamespace.classAttr(ctx);
            }
            throw new RuntimeException("%s is not a valid html namespace method".formatted(ctx.getName()));
        }).build();
    }

    public static Object htmlAttr(EvalContext ctx) {
        if (ctx.getParams().size() != 2) {
            throw new RuntimeException("html:attr() got too many arguments, got %s expected 2".formatted(ctx.getParams().size()));
        }
        Expression nameParam = (Expression)ctx.getParams().getFirst();
        Expression valueParam = (Expression)ctx.getParams().get(1);
        Object attrName = ctx.evaluate(nameParam).toCompletableFuture().resultNow();
        Object attrValue = ctx.evaluate(valueParam).toCompletableFuture().resultNow();
        if (attrName == null || attrValue == null) {
            return "";
        }
        return new RawString("%s=\"%s\"".formatted(attrName, attrValue));
    }

    public static Object classAttr(EvalContext ctx) {
        String values = ctx.getParams().stream().map(arg_0 -> ((EvalContext)ctx).evaluate(arg_0)).map(value -> value.toCompletableFuture().resultNow()).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(" "));
        if (values.isBlank()) {
            return "";
        }
        return new RawString("class=\"%s\"".formatted(values));
    }
}

