/*
 * Decompiled with CFR 0.152.
 */
package net.snemeis.configurations;

import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.HtmlEscaper;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ParserHook;
import io.quarkus.qute.Qute;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.Resolver;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.Results;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateExtension;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.ValueResolvers;
import io.quarkus.qute.Variant;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import net.snemeis.HtmlNamespace;
import net.snemeis.PropertyNotFoundThrowException;
import net.snemeis.QuteProperties;
import net.snemeis.TemplateExtensionValueResolver;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.i18n.LocaleContextHolder;

@AutoConfiguration
@EnableConfigurationProperties(value={QuteProperties.class})
public class EngineProducer {
    public static final String INJECT_NAMESPACE = "inject";
    public static final String CDI_NAMESPACE = "cdi";
    public static final String MSG_NAMESPACE = "msg";
    private static final Logger log = LoggerFactory.getLogger(EngineProducer.class);
    private final QuteProperties config;
    private final ApplicationContext applicationContext;

    @Bean
    public Engine quteEngine(QuteProperties config, List<SectionHelperFactory<?>> sectionHelperFactories, List<ValueResolver> valueResolvers, List<NamespaceResolver> namespaceResolvers, List<ParserHook> parserHooks) {
        log.debug("initializing something in qute starter");
        EngineBuilder builder = Engine.builder();
        builder.addValueResolver(ValueResolvers.thisResolver());
        builder.addValueResolver(ValueResolvers.orResolver());
        builder.addValueResolver(ValueResolvers.trueResolver());
        builder.addValueResolver(ValueResolvers.collectionResolver());
        builder.addValueResolver(ValueResolvers.mapperResolver());
        builder.addValueResolver(ValueResolvers.mapEntryResolver());
        builder.addValueResolver(ValueResolvers.mapResolver());
        builder.addValueResolver(ValueResolvers.rawResolver());
        builder.addValueResolver(ValueResolvers.logicalAndResolver());
        builder.addValueResolver(ValueResolvers.logicalOrResolver());
        builder.addValueResolver(ValueResolvers.orEmpty());
        builder.addValueResolver(ValueResolvers.arrayResolver());
        for (ValueResolver valueResolver : valueResolvers) {
            builder.addValueResolver(valueResolver);
        }
        for (ValueResolver valueResolver : this.getTemplateExtensions()) {
            builder.addValueResolver(valueResolver);
        }
        if (config.strictRendering) {
            builder.strictRendering(true);
        } else {
            builder.strictRendering(false);
            builder.addResultMapper((ResultMapper)new PropertyNotFoundThrowException());
        }
        builder.addResultMapper((ResultMapper)new HtmlEscaper(List.copyOf(config.escapeContentTypes)));
        builder.addValueResolver((ValueResolver)new ReflectionValueResolver());
        builder.removeStandaloneLines(config.removeStandaloneLines);
        builder.iterationMetadataPrefix(config.iterationMetadataPrefix);
        builder.addDefaultSectionHelpers();
        for (SectionHelperFactory sectionHelperFactory : sectionHelperFactories) {
            builder.addSectionHelper(sectionHelperFactory);
        }
        builder.addNamespaceResolver(NamespaceResolver.builder((String)INJECT_NAMESPACE).resolve(this::resolveInject).build());
        builder.addNamespaceResolver(NamespaceResolver.builder((String)CDI_NAMESPACE).resolve(this::resolveInject).build());
        builder.addNamespaceResolver(NamespaceResolver.builder((String)MSG_NAMESPACE).resolve(this::resolveMessage).build());
        builder.addNamespaceResolver(HtmlNamespace.htmlNamespaceResolver());
        for (NamespaceResolver namespaceResolver : namespaceResolvers) {
            builder.addNamespaceResolver(namespaceResolver);
        }
        for (String string : config.resolverClasses) {
            Resolver resolver = this.createResolver(string);
            if (resolver instanceof NamespaceResolver) {
                builder.addNamespaceResolver((NamespaceResolver)resolver);
            } else {
                builder.addValueResolver((ValueResolver)resolver);
            }
            log.debug("added some value resolver");
        }
        builder.addLocator(this::locate);
        for (ParserHook parserHook : parserHooks) {
            builder.addParserHook(parserHook);
        }
        builder.addParserHook((ParserHook)new Qute.IndexedArgumentsParserHook());
        builder.timeout(config.timeout);
        builder.useAsyncTimeout(config.useAsyncTimeout);
        if (!config.cachingEnabled.booleanValue()) {
            Qute.disableCache();
        }
        Engine engine = builder.build();
        Qute.setEngine((Engine)engine);
        return engine;
    }

    private List<TemplateExtensionValueResolver> getTemplateExtensions() {
        Map beans = this.applicationContext.getBeansWithAnnotation(TemplateExtension.class);
        List<Method> templateExtensions = beans.values().stream().map(Object::getClass).map(Class::getMethods).map(Arrays::asList).flatMap(Collection::stream).filter(method -> method.accessFlags().contains((Object)AccessFlag.STATIC)).toList();
        return templateExtensions.stream().map(TemplateExtensionValueResolver::new).toList();
    }

    private Resolver createResolver(String resolverClassName) {
        try {
            Class<?> resolverClazz = this.getClass().getClassLoader().loadClass(resolverClassName);
            if (Resolver.class.isAssignableFrom(resolverClazz)) {
                return (Resolver)resolverClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            throw new IllegalStateException("Not a resolver: " + resolverClassName);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create resolver: " + resolverClassName, e);
        }
    }

    private Optional<TemplateLocator.TemplateLocation> locate(String path) {
        String templatePath;
        log.debug("locating template {}", (Object)path);
        if (this.config.templatePathExclude.matcher(path).matches()) {
            log.debug("skipping template because of template-exclude-path config");
            return Optional.empty();
        }
        if (this.config.devMode.booleanValue()) {
            log.debug("Resolving file-mode template: {}", (Object)(this.config.devPrefix + path));
            for (String suffix : this.config.suffixes) {
                templatePath = this.config.devPrefix + path + suffix;
                File file = new File(templatePath);
                if (!file.exists() && file.isDirectory()) continue;
                try {
                    String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                    return Optional.of(new ContentTemplateLocation(content, this.createVariant(templatePath)));
                }
                catch (Exception ex) {
                }
            }
        }
        List<String> devIgnoreFilePath = List.of("lib1", "lib2");
        boolean isExclusivelyInClassPathForExampleFragments = false;
        templatePath = this.config.prefix + path;
        log.debug("Resolving class-mode template: {}", (Object)templatePath);
        for (String suffix : this.config.suffixes) {
            templatePath = this.config.prefix + path + suffix;
            URL resourceUrl = this.getResourceAsUrl(templatePath);
            if (resourceUrl == null) continue;
            return Optional.of(new ResourceTemplateLocation(resourceUrl, this.createVariant(templatePath)));
        }
        return Optional.empty();
    }

    private URL getResourceAsUrl(String path) {
        try {
            URL resource = Objects.requireNonNull(this.getClass().getResource(path));
            return resource.toURI().toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Variant createVariant(String path) {
        String contentType;
        try {
            contentType = Files.probeContentType(Path.of(path, new String[0]));
        }
        catch (Exception ex) {
            log.warn("could not determine content type of template");
            contentType = "application/octet-stream";
        }
        return new Variant(this.config.defaultLocale, this.config.defaultCharset, contentType);
    }

    private Object resolveInject(EvalContext ctx) {
        if (this.applicationContext.containsBean(ctx.getName())) {
            return this.applicationContext.getBean(ctx.getName());
        }
        return Results.NotFound.from((EvalContext)ctx);
    }

    private Object resolveMessage(EvalContext ctx) {
        Locale locale = LocaleContextHolder.getLocale();
        List<Object> params = ctx.getParams().stream().map(arg_0 -> ((EvalContext)ctx).evaluate(arg_0)).map(CompletionStage::toCompletableFuture).map(CompletableFuture::resultNow).toList();
        String key = (String)params.getFirst();
        List<Object> args = new ArrayList();
        if (params.size() > 1) {
            args = params.subList(1, params.size());
        }
        return this.applicationContext.getMessage(key, args.toArray(), locale);
    }

    @Generated
    public EngineProducer(QuteProperties config, ApplicationContext applicationContext) {
        this.config = config;
        this.applicationContext = applicationContext;
    }

    static class ContentTemplateLocation
    implements TemplateLocator.TemplateLocation {
        private final String content;
        private final Optional<Variant> variant;

        ContentTemplateLocation(String content, Variant variant) {
            this.content = content;
            this.variant = Optional.ofNullable(variant);
        }

        public Reader read() {
            return new StringReader(this.content);
        }

        public Optional<Variant> getVariant() {
            return this.variant;
        }
    }

    static class ResourceTemplateLocation
    implements TemplateLocator.TemplateLocation {
        private final URL resource;
        private final Optional<Variant> variant;

        ResourceTemplateLocation(URL resource, Variant variant) {
            this.resource = resource;
            this.variant = Optional.ofNullable(variant);
        }

        public Reader read() {
            Charset charset = null;
            if (this.variant.isPresent()) {
                charset = this.variant.get().getCharset();
            }
            if (charset == null) {
                charset = StandardCharsets.UTF_8;
            }
            try {
                return new InputStreamReader(this.resource.openStream(), charset);
            }
            catch (IOException e) {
                return null;
            }
        }

        public Optional<Variant> getVariant() {
            return this.variant;
        }
    }
}

