/*
 * Decompiled with CFR 0.152.
 */
package net.snemeis;

import io.quarkus.qute.Qute;
import io.quarkus.qute.Template;
import io.quarkus.qute.Variant;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import net.snemeis.TemplatePostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class QuteViewResolver
implements ViewResolver,
Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuteViewResolver.class);
    private final int order = Integer.MIN_VALUE;
    private final Boolean cachingEnabled;
    private final List<TemplatePostProcessor> postProcessors;

    public View resolveViewName(@NonNull String viewName, @NonNull Locale locale) {
        Template template;
        if (viewName == null) {
            throw new NullPointerException("viewName is marked non-null but is null");
        }
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        log.debug("resolving view {}", (Object)viewName);
        if (!this.cachingEnabled.booleanValue()) {
            Qute.engine().clearTemplates();
        }
        if ((template = Qute.engine().getTemplate(viewName)) == null) {
            return null;
        }
        return new QuteView(template, this.postProcessors);
    }

    @Generated
    public QuteViewResolver(Boolean cachingEnabled, List<TemplatePostProcessor> postProcessors) {
        this.cachingEnabled = cachingEnabled;
        this.postProcessors = postProcessors;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    static class QuteView
    implements View {
        private final Template template;
        private final List<TemplatePostProcessor> postProcessors;
        private final String contentType;

        public QuteView(Template template, List<TemplatePostProcessor> postProcessors) {
            this.template = template;
            this.postProcessors = postProcessors;
            this.contentType = template.getVariant().map(Variant::getContentType).orElse("text/plain");
        }

        public String getContentType() {
            return this.contentType;
        }

        public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            String html = this.template.render(model);
            for (TemplatePostProcessor processor : this.postProcessors) {
                if (!processor.appliesTo(request).booleanValue()) continue;
                html = processor.process(html);
            }
            response.setContentType(this.contentType);
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.getWriter().write(html);
        }
    }
}

