/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.ore.update;

import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public class UpdateCheckConfig {
    @Comment(value="Enable or disable automatic update checking")
    @Setting(value="Enabled")
    public boolean enabled = true;
    @Comment(value="Interval in hours between update checking repetitions, 0 to disable")
    @Setting(value="RepetitionInterval")
    public int repetitionInterval = 12;
    @Comment(value="Delay in milliseconds before sending a message to the console, -1 to disable message")
    @Setting(value="ConsoleDelay")
    public int consoleDelay = 1000;
    @Comment(value="Delay in milliseconds before sending a message after a player connection, -1 to disable message")
    @Setting(value="PlayerDelay")
    public int playerDelay = 1000;

    public void normalize() {
        this.repetitionInterval = Math.max(this.repetitionInterval, 0);
        this.consoleDelay = Math.max(this.consoleDelay, -1);
        this.playerDelay = Math.max(this.playerDelay, -1);
        if (this.consoleDelay == -1 && this.playerDelay == -1) {
            this.enabled = false;
        }
    }
}

