/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.ore.project;

import com.google.gson.JsonObject;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.smoofyuniverse.ore.OreAPI;
import net.smoofyuniverse.ore.project.OreProject;

public class OreVersion {
    public final OreProject project;
    public final String name;
    public final Instant createdAt;
    public final Map<String, String> dependencies;

    public OreVersion(OreProject project, String name, Instant createdAt, Map<String, String> dependencies) {
        if (project == null) {
            throw new IllegalArgumentException("project");
        }
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        if (createdAt == null) {
            throw new IllegalArgumentException("createdAt");
        }
        this.project = project;
        this.name = name;
        this.createdAt = createdAt;
        this.dependencies = Collections.unmodifiableMap(dependencies);
    }

    public Optional<String> getPage() {
        return this.project.getPage().map(p -> p + "/versions/" + this.name);
    }

    static OreVersion from(OreProject project, JsonObject obj) {
        HashMap<String, String> dependencies = new HashMap<String, String>();
        for (Object e : obj.getAsJsonArray("dependencies")) {
            JsonObject d = (JsonObject)e;
            dependencies.put(d.get("plugin_id").getAsString(), d.get("version").getAsString());
        }
        return new OreVersion(project, obj.get("name").getAsString(), OreAPI.parseInstant(obj.get("created_at").getAsString()), dependencies);
    }

    public static Optional<OreVersion> getLatest(OreVersion[] versions, Predicate<OreVersion> predicate) {
        OreVersion latestVersion = null;
        for (OreVersion version : versions) {
            if (latestVersion != null && !version.createdAt.isAfter(latestVersion.createdAt)) continue;
            try {
                if (!predicate.test(version)) continue;
                latestVersion = version;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.ofNullable(latestVersion);
    }
}

