/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.ore.project;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.util.Optional;
import net.smoofyuniverse.ore.OreAPI;
import net.smoofyuniverse.ore.project.OreVersion;

public class OreProject {
    public final String pluginId;
    public String owner;
    public String name;

    public OreProject(String pluginId) {
        if (pluginId == null || pluginId.isEmpty()) {
            throw new IllegalArgumentException("pluginId");
        }
        this.pluginId = pluginId;
    }

    public Optional<String> getPage() {
        if (this.owner == null || this.name == null) {
            return Optional.empty();
        }
        return Optional.of("https://ore.spongepowered.org/" + this.owner + "/" + this.name);
    }

    public OreVersion[] getVersions(OreAPI api) throws IOException {
        return this.getVersions(api, 0, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OreVersion[] getVersions(OreAPI api, int offset, int limit) throws IOException {
        if (offset < 0) {
            throw new IllegalArgumentException("offset");
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("limit");
        }
        HttpURLConnection co = null;
        try {
            co = api.openConnection("projects/" + this.pluginId + "/versions?offset=" + offset + "&limit=" + limit);
            co.connect();
            if (co.getResponseCode() == 404) {
                OreVersion[] oreVersionArray = new OreVersion[]{};
                return oreVersionArray;
            }
            JsonArray result = ((JsonObject)api.gson.fromJson((Reader)new InputStreamReader(co.getInputStream()), JsonObject.class)).getAsJsonArray("result");
            OreVersion[] versions = new OreVersion[result.size()];
            for (int i = 0; i < versions.length; ++i) {
                versions[i] = OreVersion.from(this, (JsonObject)result.get(i));
            }
            OreVersion[] oreVersionArray = versions;
            return oreVersionArray;
        }
        finally {
            if (co != null) {
                co.disconnect();
            }
        }
    }
}

