/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.ore;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Instant;
import java.util.Optional;
import net.smoofyuniverse.ore.OreAPI;

public class SessionManager {
    private final URL authenticationUrl;
    private final String apiKey;
    private final Gson gson;
    private Instant expiration;
    private String session;

    public SessionManager(URL authenticationUrl, String apiKey, Gson gson) {
        if (authenticationUrl == null) {
            throw new IllegalArgumentException("authenticationUrl");
        }
        if (gson == null) {
            throw new IllegalArgumentException("gson");
        }
        this.authenticationUrl = authenticationUrl;
        this.apiKey = apiKey;
        this.gson = gson;
    }

    public Instant getExpiration() {
        if (this.expiration == null) {
            throw new IllegalStateException("No session");
        }
        return this.expiration;
    }

    public Optional<String> getSession() {
        return Optional.ofNullable(this.session);
    }

    public String getOrCreateSession() throws IOException {
        if (this.session == null || this.expiration.toEpochMilli() - System.currentTimeMillis() < 30000L) {
            this.authenticate();
        }
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate() throws IOException {
        HttpURLConnection co = null;
        try {
            co = (HttpURLConnection)this.authenticationUrl.openConnection();
            co.setRequestMethod("POST");
            OreAPI.configureConnection(co);
            if (this.apiKey != null) {
                co.setRequestProperty("Authorization", "OreApi apikey=\"" + this.apiKey + "\"");
            }
            co.connect();
            try (InputStream in = co.getInputStream();){
                JsonObject obj = (JsonObject)this.gson.fromJson((Reader)new InputStreamReader(in), JsonObject.class);
                this.expiration = OreAPI.parseInstant(obj.get("expires").getAsString());
                this.session = obj.get("session").getAsString();
            }
        }
        finally {
            if (co != null) {
                co.disconnect();
            }
        }
    }
}

