/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.ore;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import net.smoofyuniverse.ore.SessionManager;

public class OreAPI {
    public static final URL DEFAULT_URL = OreAPI.getDefaultURL();
    public static final String USER_AGENT = "SmoofyOreAPI/1.0.3";
    public final URL urlBase;
    public final SessionManager sessionManager;
    public final Gson gson;

    public OreAPI() {
        this(DEFAULT_URL, null);
    }

    public OreAPI(URL urlBase, String apiKey) {
        this(urlBase, apiKey, new Gson());
    }

    public OreAPI(URL urlBase, String apiKey, Gson gson) {
        if (urlBase == null) {
            throw new IllegalArgumentException("urlBase");
        }
        if (gson == null) {
            throw new IllegalArgumentException("gson");
        }
        this.urlBase = urlBase;
        this.sessionManager = new SessionManager(this.getUncheckedURL("authenticate"), apiKey, gson);
        this.gson = gson;
    }

    public URL getUncheckedURL(String path) {
        try {
            return this.getURL(path);
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public URL getURL(String path) throws MalformedURLException {
        return new URL(this.urlBase.getProtocol(), this.urlBase.getHost(), this.urlBase.getPort(), this.urlBase.getFile() + path);
    }

    public HttpURLConnection openConnection(String path) throws IOException {
        HttpURLConnection co = (HttpURLConnection)this.getURL(path).openConnection();
        OreAPI.configureConnection(co);
        this.configureSession(co);
        return co;
    }

    public void configureSession(URLConnection co) throws IOException {
        co.setRequestProperty("Authorization", "OreApi session=\"" + this.sessionManager.getOrCreateSession() + "\"");
    }

    private static URL getDefaultURL() {
        try {
            return new URL("https://ore.spongepowered.org/api/v2/");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static void configureConnection(URLConnection co) {
        co.setUseCaches(false);
        co.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
        co.setRequestProperty("Pragma", "no-cache");
        co.setRequestProperty("Expires", "0");
        co.setRequestProperty("User-Agent", USER_AGENT);
    }

    public static Instant parseInstant(String value) {
        return Instant.from(OreAPI.parseOffsetDateTime(value));
    }

    public static TemporalAccessor parseOffsetDateTime(String value) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(value);
    }
}

