/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.keyring.windows;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.nio.charset.StandardCharsets;
import net.smoofyuniverse.keyring.Keyring;
import net.smoofyuniverse.keyring.PasswordAccessException;
import net.smoofyuniverse.keyring.UnsupportedBackendException;
import net.smoofyuniverse.keyring.windows.Advapi32;
import net.smoofyuniverse.keyring.windows.CREDENTIAL;
import net.smoofyuniverse.keyring.windows.Kernel32;

public class CredentialManagerKeyring
implements Keyring {
    public CredentialManagerKeyring() throws UnsupportedBackendException {
        if (Advapi32.INSTANCE == null || Kernel32.INSTANCE == null) {
            throw new UnsupportedBackendException("Failed to load native libraries");
        }
    }

    @Override
    public String getBackendName() {
        return "Windows Credential Manager";
    }

    protected String getTargetName(String service, String account) {
        if (account.isEmpty()) {
            return service;
        }
        return service + "\\" + account;
    }

    @Override
    public String getPassword(String service, String account) throws PasswordAccessException {
        Keyring.validateService(service);
        Keyring.validateAccount(account);
        PointerByReference ref = new PointerByReference();
        boolean success = Advapi32.INSTANCE.CredReadA(this.getTargetName(service, account), 1, 0, ref);
        if (!success) {
            int error = Kernel32.INSTANCE.GetLastError();
            if (error == 1168) {
                return null;
            }
            throw new PasswordAccessException(CredentialManagerKeyring.errorCodeToMessage(error));
        }
        CREDENTIAL cred = new CREDENTIAL(ref.getValue());
        try {
            if (cred.CredentialBlobSize == 0) {
                String string = "";
                return string;
            }
            byte[] passwordBytes = cred.CredentialBlob.getByteArray(0L, cred.CredentialBlobSize);
            String string = new String(passwordBytes, StandardCharsets.UTF_16LE);
            return string;
        }
        catch (Exception e) {
            throw new PasswordAccessException(e);
        }
        finally {
            Advapi32.INSTANCE.CredFree(ref.getValue());
        }
    }

    @Override
    public void setPassword(String service, String account, String password) throws PasswordAccessException {
        int error;
        boolean success;
        Keyring.validateService(service);
        Keyring.validateAccount(account);
        Keyring.validatePassword(password);
        String target = this.getTargetName(service, account);
        if (password == null) {
            success = Advapi32.INSTANCE.CredDeleteA(target, 1, 0);
        } else {
            Memory passwordMemory;
            byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_16LE);
            if (passwordBytes.length == 0) {
                passwordMemory = null;
            } else {
                passwordMemory = new Memory((long)passwordBytes.length);
                passwordMemory.write(0L, passwordBytes, 0, passwordBytes.length);
            }
            CREDENTIAL cred = new CREDENTIAL();
            cred.TargetName = target;
            cred.UserName = account;
            cred.Type = 1;
            cred.CredentialBlob = passwordMemory;
            cred.CredentialBlobSize = passwordBytes.length;
            cred.Persist = 2;
            success = Advapi32.INSTANCE.CredWriteA(cred, 0);
            if (passwordMemory != null) {
                passwordMemory.clear();
            }
        }
        if (!success && (error = Kernel32.INSTANCE.GetLastError()) != 1168) {
            throw new PasswordAccessException(CredentialManagerKeyring.errorCodeToMessage(error));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String errorCodeToMessage(int errorCode) {
        PointerByReference buffer = new PointerByReference();
        int nLen = Kernel32.INSTANCE.FormatMessageA(4864, null, errorCode, 0, buffer, 0, null);
        if (nLen == 0) {
            return "Error code: " + errorCode;
        }
        Pointer ptr = buffer.getValue();
        try {
            String string = ptr.getString(0L).trim();
            return string;
        }
        finally {
            Kernel32.INSTANCE.LocalFree(ptr);
        }
    }
}

