/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.keyring;

import com.sun.jna.Platform;
import net.smoofyuniverse.keyring.PasswordAccessException;
import net.smoofyuniverse.keyring.UnsupportedBackendException;
import net.smoofyuniverse.keyring.linux.SecretServiceKeyring;
import net.smoofyuniverse.keyring.mac.KeychainKeyring;
import net.smoofyuniverse.keyring.windows.CredentialManagerKeyring;

public interface Keyring {
    public static Keyring create() throws UnsupportedBackendException {
        switch (Platform.getOSType()) {
            case 0: {
                return new KeychainKeyring();
            }
            case 1: {
                return new SecretServiceKeyring();
            }
            case 2: 
            case 6: {
                return new CredentialManagerKeyring();
            }
        }
        throw new UnsupportedBackendException("Unsupported OS");
    }

    public String getBackendName();

    public String getPassword(String var1, String var2) throws PasswordAccessException;

    public void setPassword(String var1, String var2, String var3) throws PasswordAccessException;

    public static void validateService(String service) {
        if (service == null) {
            throw new IllegalArgumentException("service is null");
        }
        if (service.isEmpty()) {
            throw new IllegalArgumentException("service is empty");
        }
    }

    public static void validateAccount(String account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
    }

    public static void validatePassword(String password) {
        if (password != null && password.indexOf(0) != -1) {
            throw new IllegalArgumentException("password contains a NULL character");
        }
    }
}

