/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.testing.jacoco.tasks;

import java.io.File;
import javax.inject.Inject;
import net.smoofyuniverse.internal.jacoco.AntJacocoInstrument;
import net.smoofyuniverse.testing.jacoco.tasks.JacocoBase;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;

@Incubating
@CacheableTask
public abstract class JacocoOfflineInstrumentation
extends JacocoBase {
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public abstract ConfigurableFileCollection getInputClassDirs();

    public void sourceSets(SourceSet ... sourceSets) {
        for (SourceSet sourceSet : sourceSets) {
            this.getInputClassDirs().from(new Object[]{sourceSet.getOutput().getClassesDirs()});
        }
    }

    @OutputDirectory
    public abstract DirectoryProperty getOutputDir();

    @Inject
    protected abstract IsolatedAntBuilder getAntBuilder();

    @TaskAction
    public void generate() {
        Directory outputDir = (Directory)this.getOutputDir().get();
        this.getProject().delete(new Object[]{outputDir});
        new AntJacocoInstrument(this.getAntBuilder()).execute(this.getJacocoClasspath(), this.getInputClassDirs().filter(File::exists), outputDir);
    }
}

