/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.testing.jacoco.tasks;

import java.io.File;
import java.io.IOException;
import net.smoofyuniverse.internal.jacoco.AntJacocoCheck;
import net.smoofyuniverse.internal.jacoco.JacocoCheckResult;
import net.smoofyuniverse.internal.jacoco.rules.JacocoViolationRulesContainerImpl;
import net.smoofyuniverse.testing.jacoco.tasks.JacocoReportBase;
import net.smoofyuniverse.testing.jacoco.tasks.rules.JacocoViolationRulesContainer;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.reflect.Instantiator;

@CacheableTask
public abstract class JacocoCoverageVerification
extends JacocoReportBase {
    private final JacocoViolationRulesContainer violationRules;
    private final String projectName = this.getProject().getName();

    public JacocoCoverageVerification() {
        Instantiator instantiator = this.getInstantiator();
        this.violationRules = (JacocoViolationRulesContainer)instantiator.newInstance(JacocoViolationRulesContainerImpl.class, new Object[]{instantiator});
    }

    @Nested
    public JacocoViolationRulesContainer getViolationRules() {
        return this.violationRules;
    }

    @OutputFile
    protected File getDummyOutputFile() {
        return new File(this.getTemporaryDir(), "success.txt");
    }

    public JacocoViolationRulesContainer violationRules(Action<? super JacocoViolationRulesContainer> configureAction) {
        configureAction.execute((Object)this.violationRules);
        return this.violationRules;
    }

    @TaskAction
    public void check() throws IOException {
        JacocoCheckResult checkResult = new AntJacocoCheck(this.getAntBuilder()).execute(this.getJacocoClasspath(), this.projectName, this.getAllClassDirs().filter(File::exists), this.getAllSourceDirs().filter(File::exists), this.getExecutionData().filter(File::exists), this.getViolationRules());
        if (!checkResult.isSuccess()) {
            throw new GradleException(checkResult.getFailureMessage());
        }
        this.getDummyOutputFile().createNewFile();
    }
}

