/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.testing.jacoco.plugins;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.smoofyuniverse.internal.jacoco.JacocoAgentJar;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.LocalState;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.internal.RelativePathUtil;

public abstract class JacocoTaskExtension {
    private final JacocoAgentJar agent;
    private final JavaForkOptions task;
    private boolean enabled = true;
    private final Property<Boolean> offline;
    private final ConfigurableFileCollection offlineInstrumentedClasses;
    private final Property<File> destinationFile;
    private List<String> includes = new ArrayList<String>();
    private List<String> excludes = new ArrayList<String>();
    private List<String> excludeClassLoaders = new ArrayList<String>();
    private boolean includeNoLocationClasses;
    private String sessionId;
    private boolean dumpOnExit = true;
    private Output output = Output.FILE;
    private String address;
    private int port;
    private File classDumpDir;
    private boolean jmx;

    @Inject
    public JacocoTaskExtension(ObjectFactory objects, JacocoAgentJar agent, JavaForkOptions task) {
        this.agent = agent;
        this.task = task;
        this.offline = objects.property(Boolean.class).convention((Object)false);
        this.offlineInstrumentedClasses = objects.fileCollection();
        this.destinationFile = objects.property(File.class);
    }

    @Input
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Incubating
    @Input
    public Property<Boolean> getOffline() {
        return this.offline;
    }

    @Incubating
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public ConfigurableFileCollection getOfflineInstrumentedClasses() {
        return this.offlineInstrumentedClasses;
    }

    @Nullable
    @Optional
    @OutputFile
    public File getDestinationFile() {
        return (File)this.destinationFile.getOrNull();
    }

    public void setDestinationFile(Provider<File> destinationFile) {
        this.destinationFile.set(destinationFile);
    }

    public void setDestinationFile(File destinationFile) {
        this.destinationFile.set((Object)destinationFile);
    }

    @Nullable
    @Optional
    @Input
    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(@Nullable List<String> includes) {
        this.includes = includes;
    }

    @Nullable
    @Optional
    @Input
    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(@Nullable List<String> excludes) {
        this.excludes = excludes;
    }

    @Nullable
    @Optional
    @Input
    public List<String> getExcludeClassLoaders() {
        return this.excludeClassLoaders;
    }

    public void setExcludeClassLoaders(@Nullable List<String> excludeClassLoaders) {
        this.excludeClassLoaders = excludeClassLoaders;
    }

    @Input
    public boolean isIncludeNoLocationClasses() {
        return this.includeNoLocationClasses;
    }

    public void setIncludeNoLocationClasses(boolean includeNoLocationClasses) {
        this.includeNoLocationClasses = includeNoLocationClasses;
    }

    @Nullable
    @Optional
    @Input
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(@Nullable String sessionId) {
        this.sessionId = sessionId;
    }

    @Input
    public boolean isDumpOnExit() {
        return this.dumpOnExit;
    }

    public void setDumpOnExit(boolean dumpOnExit) {
        this.dumpOnExit = dumpOnExit;
    }

    @Input
    public Output getOutput() {
        return this.output;
    }

    public void setOutput(Output output) {
        this.output = output;
    }

    @Nullable
    @Optional
    @Input
    public String getAddress() {
        return this.address;
    }

    public void setAddress(@Nullable String address) {
        this.address = address;
    }

    @Input
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Nullable
    @Optional
    @LocalState
    public File getClassDumpDir() {
        return this.classDumpDir;
    }

    public void setClassDumpDir(@Nullable File classDumpDir) {
        this.classDumpDir = classDumpDir;
    }

    @Input
    public boolean isJmx() {
        return this.jmx;
    }

    public void setJmx(boolean jmx) {
        this.jmx = jmx;
    }

    @Classpath
    public FileCollection getAgentClasspath() {
        return this.agent.getAgentConf();
    }

    @Deprecated
    @Internal
    public String getAsJvmArg() {
        return this.getJavaAgentArg();
    }

    @Incubating
    public List<String> asJvmArgs() {
        if (((Boolean)this.getOffline().get()).booleanValue()) {
            ImmutableList.Builder list = ImmutableList.builder();
            this.generateAgentParameters(nameAndValue -> list.add((Object)("-Djacoco-agent." + nameAndValue)));
            return list.build();
        }
        return ImmutableList.of((Object)this.getJavaAgentArg());
    }

    private String getJavaAgentArg() {
        StringBuilder builder = new StringBuilder();
        builder.append("-javaagent:");
        builder.append(this.agent.getJar().getAbsolutePath());
        builder.append('=');
        StringJoiner joiner = new StringJoiner(",");
        this.generateAgentParameters(joiner::add);
        builder.append(joiner);
        return builder.toString();
    }

    private void generateAgentParameters(Consumer<String> consumer) {
        ParameterFormatter formatter = new ParameterFormatter(this.task.getWorkingDir(), consumer);
        formatter.add("destfile", this.getDestinationFile());
        formatter.add("append", true);
        formatter.add("includes", this.getIncludes());
        formatter.add("excludes", this.getExcludes());
        formatter.add("exclclassloader", this.getExcludeClassLoaders());
        if (this.agent.supportsInclNoLocationClasses()) {
            formatter.add("inclnolocationclasses", this.isIncludeNoLocationClasses());
        }
        formatter.add("sessionid", this.getSessionId());
        formatter.add("dumponexit", this.isDumpOnExit());
        formatter.add("output", this.getOutput().getAsArg());
        formatter.add("address", this.getAddress());
        formatter.add("port", this.getPort());
        formatter.add("classdumpdir", this.getClassDumpDir());
        if (this.agent.supportsJmx()) {
            formatter.add("jmx", this.isJmx());
        }
    }

    private static class ParameterFormatter {
        private final File workingDirectory;
        private final Consumer<String> consumer;

        public ParameterFormatter(File workingDirectory, Consumer<String> consumer) {
            this.workingDirectory = workingDirectory;
            this.consumer = consumer;
        }

        public void add(String name, @Nullable Object value) {
            if (value == null) {
                return;
            }
            String formatted = value instanceof Collection ? (((Collection)value).isEmpty() ? null : Joiner.on((char)':').join((Iterable)((Collection)value))) : (value instanceof File ? RelativePathUtil.relativePath((File)this.workingDirectory, (File)((File)value)) : (value instanceof String ? (((String)value).isEmpty() ? null : (String)value) : (value instanceof Integer ? ((Integer)value == 0 ? null : value.toString()) : value.toString())));
            if (formatted != null) {
                this.consumer.accept(name + "=" + formatted);
            }
        }
    }

    public static enum Output {
        FILE,
        TCP_SERVER,
        TCP_CLIENT,
        NONE;


        public String getAsArg() {
            return this.toString().toLowerCase(Locale.US).replaceAll("_", "");
        }
    }
}

