/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.exporter;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Util {
    private static final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toHexString(byte[] bytes) {
        StringBuilder s = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            s.append(hexchars[(b & 0xF0) >> 4]).append(hexchars[b & 0xF]);
        }
        return s.toString();
    }

    public static byte[] digest(Path file) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("sha1");
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            int len;
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer)) != -1) {
                md.update(buffer, 0, len);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
    }
}

