/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.exporter;

import com.google.gson.stream.JsonWriter;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.smoofyuniverse.exporter.Constraint;
import net.smoofyuniverse.exporter.ExportConfig;
import net.smoofyuniverse.exporter.Util;
import org.gradle.api.DefaultTask;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public abstract class ExportTask
extends DefaultTask {
    private static final Logger logger = Logging.getLogger(ExportTask.class);

    @TaskAction
    public void generate() throws Exception {
        Path dir = ((Directory)this.getOutputDirectory().get()).getAsFile().toPath();
        RepositoryHandler repos = this.getProject().getRepositories();
        for (ExportConfig config : this.getConfigurations()) {
            Set exclusions = (Set)config.getExclusions().get();
            ArrayList<ResolvedArtifact> artifacts = new ArrayList<ResolvedArtifact>();
            Path destination = dir.resolve((String)config.getPath().get());
            for (ResolvedArtifact a : ((Configuration)config.getConfig().get()).getResolvedConfiguration().getResolvedArtifacts()) {
                if (exclusions.contains(a.getClassifier())) continue;
                artifacts.add(a);
            }
            if (artifacts.isEmpty() && ((Boolean)config.getSkipWhenEmpty().get()).booleanValue()) {
                Files.deleteIfExists(destination);
                continue;
            }
            ExportTask.generate((Iterable<ArtifactRepository>)repos, artifacts, destination, config.getConstraints());
        }
    }

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @Nested
    public abstract DomainObjectCollection<ExportConfig> getConfigurations();

    public static void generate(Iterable<ArtifactRepository> repos, Iterable<ResolvedArtifact> artifacts, Path destination, NamedDomainObjectCollection<Constraint> constraints) throws Exception {
        ArrayList<String> mavenRepos = new ArrayList<String>();
        for (ArtifactRepository repo : repos) {
            if (!(repo instanceof MavenArtifactRepository)) continue;
            String url = ((MavenArtifactRepository)repo).getUrl().toString();
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            mavenRepos.add(url);
        }
        Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        try (JsonWriter w = new JsonWriter((Writer)Files.newBufferedWriter(destination, new OpenOption[0]));){
            w.setIndent("  ");
            w.beginArray();
            for (ResolvedArtifact a : artifacts) {
                Constraint constraint;
                ComponentIdentifier id = a.getId().getComponentIdentifier();
                if (!(id instanceof ModuleComponentIdentifier)) continue;
                ModuleComponentIdentifier c = (ModuleComponentIdentifier)id;
                String name = c.toString();
                String path = c.getGroup().replace('.', '/') + "/" + c.getModule() + "/" + c.getVersion() + "/" + c.getModule() + "-";
                path = c instanceof MavenUniqueSnapshotComponentIdentifier ? path + ((MavenUniqueSnapshotComponentIdentifier)c).getTimestampedVersion() : path + c.getVersion();
                String classifier = a.getClassifier();
                if (classifier != null) {
                    name = name + ":" + classifier;
                    path = path + "-" + classifier;
                }
                path = path + "." + a.getExtension();
                w.beginObject();
                w.name("name");
                w.value(name);
                boolean found = false;
                for (String repoUrl : mavenRepos) {
                    String urlStr = repoUrl + path;
                    URL url = new URL(urlStr);
                    URLConnection co = url.openConnection();
                    co.setRequestProperty("User-Agent", "DependencyExporter");
                    try {
                        InputStream st = co.getInputStream();
                        Throwable throwable = null;
                        try {
                            if (st == null) continue;
                            found = true;
                            w.name("url");
                            w.value(urlStr);
                            break;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (st == null) continue;
                            if (throwable != null) {
                                try {
                                    st.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            st.close();
                        }
                    }
                    catch (FileNotFoundException st) {}
                }
                if (!found) {
                    logger.warn("Artifact URL not found.");
                    logger.warn("Name: {}", (Object)name);
                    logger.warn("Path: {}", (Object)path);
                }
                Path file = a.getFile().toPath();
                w.name("size");
                w.value(Files.size(file));
                w.name("digest");
                w.value(Util.toHexString(Util.digest(file)));
                if (classifier != null && (constraint = (Constraint)constraints.findByName(classifier)) != null) {
                    List archs;
                    List systems = (List)constraint.getSystems().getOrNull();
                    if (systems != null) {
                        w.name("systems");
                        w.beginArray();
                        for (String system : systems) {
                            w.value(system);
                        }
                        w.endArray();
                    }
                    if ((archs = (List)constraint.getArchs().getOrNull()) != null) {
                        w.name("archs");
                        w.beginArray();
                        for (String arch : archs) {
                            w.value(arch);
                        }
                        w.endArray();
                    }
                }
                w.endObject();
            }
            w.endArray();
        }
    }
}

