/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.exporter;

import java.util.Collections;
import javax.inject.Inject;
import net.smoofyuniverse.exporter.Constraint;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;

public class ExportConfig
implements Named {
    private final ObjectFactory factory;
    private final String name;
    private final Property<String> path;
    private final Property<Configuration> config;
    private final Property<Boolean> skipWhenEmpty;
    private final SetProperty<String> exclusions;
    private final NamedDomainObjectContainer<Constraint> constraints;

    @Inject
    public ExportConfig(String name, ObjectFactory factory) {
        this.factory = factory;
        this.name = name;
        this.path = factory.property(String.class);
        this.config = factory.property(Configuration.class);
        this.skipWhenEmpty = factory.property(Boolean.class);
        this.exclusions = factory.setProperty(String.class);
        this.constraints = factory.domainObjectContainer(Constraint.class);
        this.skipWhenEmpty.convention((Object)false);
    }

    @Input
    public String getName() {
        return this.name;
    }

    @Input
    public Property<String> getPath() {
        return this.path;
    }

    public void setPath(String value) {
        this.path.set((Object)value);
    }

    @Input
    public Property<Configuration> getConfig() {
        return this.config;
    }

    public void setConfig(Configuration value) {
        this.config.set((Object)value);
    }

    @Input
    public Property<Boolean> getSkipWhenEmpty() {
        return this.skipWhenEmpty;
    }

    public void setSkipWhenEmpty(boolean value) {
        this.skipWhenEmpty.set((Object)value);
    }

    @Input
    public SetProperty<String> getExclusions() {
        return this.exclusions;
    }

    public void exclude(String ... classifiers) {
        this.exclusions.addAll((Object[])classifiers);
    }

    @Nested
    public NamedDomainObjectContainer<Constraint> getConstraints() {
        return this.constraints;
    }

    public void constraint(String classifier, String system) {
        this.constraint(classifier, Collections.singleton(system));
    }

    public void constraint(String classifier, Iterable<? extends String> systems) {
        this.constraint(classifier, systems, null);
    }

    public void presetOpenJFX() {
        this.constraint("win", "windows", "x64");
        this.constraint("mac", "macos", "x64");
        this.constraint("mac-aarch64", "macos", "arm64");
        this.constraint("linux", "linux", "x64");
        this.constraint("linux-aarch64", "linux", "arm64");
    }

    public void constraint(String classifier, Iterable<? extends String> systems, Iterable<? extends String> archs) {
        Constraint constraint = new Constraint(classifier, this.factory);
        constraint.setSystems(systems);
        constraint.setArchs(archs);
        this.constraints.add((Object)constraint);
    }

    public void constraint(String classifier, String system, String arch) {
        this.constraint(classifier, Collections.singleton(system), Collections.singleton(arch));
    }

    public void removeConstraint(String classifier) {
        Constraint constraint = (Constraint)this.constraints.findByName(classifier);
        if (constraint != null) {
            this.constraints.remove((Object)constraint);
        }
    }
}

