/*
 * Decompiled with CFR 0.152.
 */
package net.sinofool.alipay.base;

import java.io.ByteArrayOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sinofool.alipay.AlipayException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OneLevelOnlyXML {
    private static final Logger LOG = LoggerFactory.getLogger(OneLevelOnlyXML.class);
    private Document doc;
    private Element root;

    public void createRootElement(String tag) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.newDocument();
            this.root = this.doc.createElement(tag);
            this.doc.appendChild(this.root);
        }
        catch (RuntimeException e) {
            LOG.warn("Cannot create XML document:", (Throwable)e);
            throw new AlipayException(e);
        }
        catch (Exception e) {
            LOG.warn("Cannot create XML document", (Throwable)e);
            throw new AlipayException(e);
        }
    }

    public void createChild(String tag, String value) {
        if (this.doc == null || this.root == null) {
            return;
        }
        Element encrypt = this.doc.createElement(tag);
        encrypt.appendChild(this.doc.createTextNode(value));
        this.root.appendChild(encrypt);
    }

    public void createChild(String tag, int value) {
        this.createChild(tag, String.valueOf(value));
    }

    public String toXMLString() {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(this.doc), new StreamResult(out));
            return out.toString("utf-8");
        }
        catch (RuntimeException e) {
            LOG.warn("Cannot serialize to XML:", (Throwable)e);
            throw new AlipayException(e);
        }
        catch (Exception e) {
            LOG.warn("Cannot serialize to XML", (Throwable)e);
            throw new AlipayException(e);
        }
    }
}

