/*
 * Decompiled with CFR 0.152.
 */
package net.sinofool.alipay;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import net.sinofool.alipay.AlipayConfig;
import net.sinofool.alipay.AlipayHttpClient;
import net.sinofool.alipay.AlipayRequestData;
import net.sinofool.alipay.AlipayResponseData;
import net.sinofool.alipay.base.AbstractAlipay;
import net.sinofool.alipay.base.GroupStringPair;
import net.sinofool.alipay.base.StringPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class WapDirectSDK
extends AbstractAlipay {
    private static final Logger LOG = LoggerFactory.getLogger(WapDirectSDK.class);
    private static final String SIGN_WAP_RSA = "0001";
    private static final String SIGN_WAP_MD5 = "MD5";
    private final AlipayHttpClient http;

    public WapDirectSDK(AlipayConfig config, AlipayHttpClient httpClient) {
        super(config);
        this.http = httpClient;
    }

    public AlipayRequestData makeSimpleWapTradeDirect(String tradeId, String subject, double total, String callBackUrl, String notifyUrl, String merchantUrl) {
        AlipayRequestData a = new AlipayRequestData();
        a.setString("service", "alipay.wap.trade.create.direct");
        a.setString("format", "xml");
        a.setString("v", "2.0");
        a.setString("partner", this.config.getPartnerId());
        a.setString("req_id", tradeId);
        a.setString("req_data", "direct_trade_create_req");
        a.setReqString("subject", subject);
        a.setReqString("out_trade_no", tradeId);
        a.setReqString("total_fee", String.valueOf(total));
        a.setReqString("seller_account_name", this.config.getSellerAccount());
        a.setReqString("call_back_url", callBackUrl);
        a.setReqString("notify_url", notifyUrl);
        a.setReqString("merchant_url", merchantUrl);
        return a;
    }

    private AlipayRequestData makeWapAuthAndExecute(String token) {
        AlipayRequestData a = new AlipayRequestData();
        a.setString("service", "alipay.wap.auth.authAndExecute");
        a.setString("format", "xml");
        a.setString("v", "2.0");
        a.setString("partner", this.config.getPartnerId());
        a.setString("req_data", "auth_and_execute_req");
        a.setReqString("request_token", token);
        return a;
    }

    private List<StringPair> sign(List<StringPair> p) {
        String sign = null;
        if (this.preferRSA) {
            p.add(new StringPair("sec_id", SIGN_WAP_RSA));
            Collections.sort(p);
            sign = this.signRSA(p);
        } else {
            p.add(new StringPair("sec_id", SIGN_WAP_MD5));
            Collections.sort(p);
            sign = this.signMD5(p);
        }
        p.add(new StringPair("sign", sign));
        return p;
    }

    public String create(AlipayRequestData request) {
        List<StringPair> p = this.sign(request.getSortedParameters());
        try {
            String auth = this.http.get("wappaygw.alipay.com", 443, "https", "/service/rest.htm?" + this.join(p, true, false));
            GroupStringPair params = this.parseQueryString(auth);
            this.decrypt(params);
            AlipayResponseData res = AlipayResponseData.parse(params);
            boolean verified = false;
            if (this.preferRSA && res.getString("sec_id").equals(SIGN_WAP_RSA)) {
                verified = this.verifyRSA(res.getString("sign"), res.getSortedParameters("sign"));
            } else if (res.getString("sec_id").equals(SIGN_WAP_MD5)) {
                verified = this.verifyMD5(res.getString("sign"), res.getSortedParameters("sign"));
            }
            if (!verified) {
                return null;
            }
            String token = res.getExtraString("request_token");
            if (token == null) {
                LOG.trace("Cannot find token in response");
                return null;
            }
            p = this.sign(this.makeWapAuthAndExecute(token).getSortedParameters());
            return "https://wappaygw.alipay.com/service/rest.htm?" + this.join(p, true, false);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Failed to create wap direct trade", (Throwable)e);
            return null;
        }
        catch (SAXException e) {
            LOG.warn("Failed to create wap direct trade", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.warn("Failed to create wap direct trade", (Throwable)e);
            return null;
        }
        catch (ParserConfigurationException e) {
            LOG.warn("Failed to create wap direct trade", (Throwable)e);
            return null;
        }
    }

    public void decrypt(GroupStringPair params) {
        if (!this.preferRSA) {
            return;
        }
        String sec = params.get("sec_id");
        if (sec == null || !SIGN_WAP_RSA.equals(sec)) {
            return;
        }
        if (params.get("res_data") != null) {
            String value = params.get("res_data");
            params.update("res_data", this.decrypt(value));
        } else if (params.get("notify_data") != null) {
            String value = params.get("notify_data");
            params.update("notify_data", this.decrypt(value));
        }
    }

    public boolean verifyCallback(AlipayResponseData response) {
        List<StringPair> parameterList = response.getOrderedParameters("sign", "sign_type");
        String type = response.getString("sign_type");
        if (type.equals(SIGN_WAP_RSA)) {
            return this.verifyRSA(response.getString("sign"), parameterList);
        }
        if (type.equals(SIGN_WAP_MD5)) {
            return this.verifyMD5(response.getString("sign"), parameterList);
        }
        return false;
    }

    public boolean verifyNotify(AlipayResponseData response) {
        List<StringPair> parameterList = response.getOrderedParameters("sign");
        String type = response.getString("sec_id");
        if (type.equals(SIGN_WAP_RSA)) {
            StringBuilder content = new StringBuilder();
            content.append("service=").append(response.getString("service"));
            content.append("&v=").append(response.getString("v"));
            content.append("&sec_id=").append(response.getString("sec_id"));
            content.append("&notify_data=").append(response.getString("notify_data"));
            return this.rsaVerify(content.toString(), response.getString("sign"));
        }
        if (type.equals(SIGN_WAP_MD5)) {
            return this.verifyMD5(response.getString("sign"), parameterList);
        }
        return false;
    }
}

