/*
 * Decompiled with CFR 0.152.
 */
package net.sinofool.alipay;

import java.util.List;
import net.sinofool.alipay.AlipayConfig;
import net.sinofool.alipay.AlipayHttpClient;
import net.sinofool.alipay.AlipayRequestData;
import net.sinofool.alipay.AlipayResponseData;
import net.sinofool.alipay.base.AbstractAlipay;
import net.sinofool.alipay.base.StringPair;
import net.sinofool.alipay.thirdparty.org.json.JSONArray;
import net.sinofool.alipay.thirdparty.org.json.JSONObject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class QRDirectSDK
extends AbstractAlipay {
    private final AlipayHttpClient http;

    public QRDirectSDK(AlipayConfig config, AlipayHttpClient http) {
        super(config);
        this.http = http;
    }

    public AlipayRequestData makeAddDirectPayQR(BizData bizData) {
        AlipayRequestData request = new AlipayRequestData();
        request.setString("service", "alipay.mobile.qrcode.manage");
        request.setString("partner", this.config.getPartnerId());
        request.setString("_input_charset", "utf-8");
        DateTime beijing = new DateTime().toDateTime(DateTimeZone.forID((String)"Asia/Shanghai"));
        request.setString("timestamp", beijing.toString("yyyy-MM-dd HH:mm:ss"));
        request.setString("method", "add");
        request.setString("biz_type", "10");
        request.setString("biz_data", bizData.toJSON().toString());
        return request;
    }

    private String sign(AlipayRequestData request) {
        return this.signMD5(request.getSortedParameters());
    }

    public String create(AlipayRequestData request) {
        List<StringPair> signed = request.getSortedParameters();
        signed.add(new StringPair("sign", this.sign(request)));
        request.setString("sign_type", "MD5");
        String body = this.join(signed, true, false);
        String post = this.http.post("mapi.alipay.com", 443, "https", "/gateway.do?_input_charset=utf-8", body);
        return post;
    }

    public boolean verifyReturn(AlipayResponseData p) {
        List<StringPair> params = p.getSortedParameters("sign", "sign_type");
        String sign = this.signMD5(params);
        return sign.equals(p.getString("sign"));
    }

    public boolean verifyNotify(AlipayResponseData p) {
        List<StringPair> params = p.getSortedParameters("sign", "sign_type");
        String sign = this.signMD5(params);
        return sign.equals(p.getString("sign"));
    }

    public static class BizData {
        private final String trade_type;
        private final String need_address;
        private final Good goods_info;
        private final String return_url;
        private final String notify_url;
        private final ExtInfo ext_info;

        public BizData(String tradeType, String needAddress, Good goodsInfo, String returnURL, String notifyURL, ExtInfo extInfo) {
            this.trade_type = tradeType;
            this.need_address = needAddress;
            this.goods_info = goodsInfo;
            this.return_url = returnURL;
            this.notify_url = notifyURL;
            this.ext_info = extInfo;
        }

        public JSONObject toJSON() {
            JSONObject biz = new JSONObject();
            biz.put("trade_type", this.trade_type);
            biz.put("need_address", this.need_address);
            biz.put("goods_info", this.goods_info.toJSON());
            biz.put("return_url", this.return_url);
            biz.put("notify_url", this.notify_url);
            biz.put("ext_info", this.ext_info.toJSON());
            return biz;
        }
    }

    public static class ExtInfo {
        private final ExtField[] ext_field;
        private final String single_limit;

        public ExtInfo(String singleLimit, ExtField ... extFields) {
            this.ext_field = extFields;
            this.single_limit = singleLimit;
        }

        public JSONObject toJSON() {
            JSONObject extInfo = new JSONObject();
            JSONArray extFields = new JSONArray();
            for (ExtField ext : this.ext_field) {
                extFields.put(ext.toJSON());
            }
            extInfo.put("ext_field", extFields);
            extInfo.put("single_limit", this.single_limit);
            return extInfo;
        }
    }

    public static class ExtField {
        private final String input_title;
        private final String input_regex;

        public ExtField(String inputTitle, String inputRegex) {
            this.input_title = inputTitle;
            this.input_regex = inputRegex;
        }

        public JSONObject toJSON() {
            JSONObject extPhone = new JSONObject();
            extPhone.put("input_title", this.input_title);
            extPhone.put("input_regex", this.input_regex);
            return extPhone;
        }
    }

    public static class Good {
        private final String id;
        private final String name;
        private final String price;
        private final String sku_title;
        private final Sku[] sku;

        public Good(String id, String name, String price, String skuTitle, Sku ... sku) {
            this.id = id;
            this.name = name;
            this.price = price;
            this.sku_title = skuTitle;
            this.sku = sku;
        }

        public JSONObject toJSON() {
            JSONObject goods = new JSONObject();
            goods.put("id", this.id);
            goods.put("name", this.name);
            goods.put("price", this.price);
            goods.put("sku_title", this.sku_title);
            JSONArray skus = new JSONArray();
            for (Sku s : this.sku) {
                skus.put(s.toJSON());
            }
            goods.put("sku", skus);
            return goods;
        }
    }

    public static class Sku {
        private final String sku_id;
        private final String sku_name;
        private final String sku_price;

        public Sku(String id, String name, String price) {
            this.sku_id = id;
            this.sku_name = name;
            this.sku_price = price;
        }

        public JSONObject toJSON() {
            JSONObject sku = new JSONObject();
            sku.put("sku_id", this.sku_id);
            sku.put("sku_name", this.sku_name);
            sku.put("sku_price", this.sku_price);
            return sku;
        }
    }
}

