/*
 * Decompiled with CFR 0.152.
 */
package net.sinofool.alipay;

import java.util.List;
import net.sinofool.alipay.AlipayConfig;
import net.sinofool.alipay.AlipayRequestData;
import net.sinofool.alipay.AlipayResponseData;
import net.sinofool.alipay.base.AbstractAlipay;
import net.sinofool.alipay.base.StringPair;

public class PCDirectSDK
extends AbstractAlipay {
    public PCDirectSDK(AlipayConfig config) {
        super(config);
    }

    public String getActionURL() {
        return "https://mapi.alipay.com/gateway.do?_input_charset=utf-8";
    }

    public AlipayRequestData makeSimpleDirectPayRequest(String tradeId, String subject, double total, String notifyURL, String returnURL, String errorNotifyURL) {
        AlipayRequestData data = new AlipayRequestData();
        data.setString("service", "create_direct_pay_by_user");
        data.setString("partner", this.config.getPartnerId());
        data.setString("_input_charset", "utf-8");
        data.setString("notify_url", notifyURL);
        data.setString("return_url", returnURL);
        data.setString("error_notify_url", errorNotifyURL);
        data.setString("out_trade_no", tradeId);
        data.setString("subject", subject);
        data.setString("payment_type", "1");
        data.setString("total_fee", String.valueOf(total));
        data.setString("seller_id", this.config.getPartnerId());
        return data;
    }

    public AlipayRequestData makeVerifyRequest(String notifyId) {
        AlipayRequestData data = new AlipayRequestData();
        data.setString("service", "notify_verify");
        data.setString("partner", this.config.getPartnerId());
        data.setString("_input_charset", "utf-8");
        data.setString("notify_id", notifyId);
        return data;
    }

    private List<StringPair> sign(List<StringPair> p) {
        String sign;
        if (this.preferRSA) {
            sign = this.signRSA(p);
            p.add(new StringPair("sign_type", "RSA"));
        } else {
            sign = this.signMD5(p);
            p.add(new StringPair("sign_type", "MD5"));
        }
        p.add(new StringPair("sign", sign));
        return p;
    }

    public List<StringPair> create(AlipayRequestData request) {
        return this.sign(request.getSortedParameters());
    }

    public boolean verify(AlipayResponseData response) {
        List<StringPair> parameterList = response.getSortedParameters("sign", "sign_type");
        if (response.getString("sign_type").equals("RSA")) {
            return this.verifyRSA(response.getString("sign"), parameterList);
        }
        if (response.getString("sign_type").equals("MD5")) {
            return this.verifyMD5(response.getString("sign"), parameterList);
        }
        return false;
    }
}

