/*
 * Decompiled with CFR 0.152.
 */
package net.sinofool.alipay;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sinofool.alipay.AlipayConfig;
import net.sinofool.alipay.base.AbstractAlipay;
import net.sinofool.alipay.base.StringPair;

public class AlipayPCDirect
extends AbstractAlipay {
    public PCURLs createPCURLs(String notifyURL, String returnURL, String errorNotifyURL) {
        PCURLs u = new PCURLs();
        u.notifyURL = notifyURL;
        u.returnURL = returnURL;
        u.errorNotifyURL = errorNotifyURL;
        return u;
    }

    public AlipayPCDirect(AlipayConfig config) {
        super(config);
    }

    public String getPCActionURL() {
        return "https://mapi.alipay.com/gateway.do?_input_charset=utf-8";
    }

    public List<StringPair> createDirectPay(String tradeId, String subject, double total, PCURLs u) {
        String sign;
        ArrayList<StringPair> p = new ArrayList<StringPair>();
        p.add(new StringPair("service", "create_direct_pay_by_user"));
        p.add(new StringPair("partner", this.config.getPartnerId()));
        p.add(new StringPair("_input_charset", "utf-8"));
        p.add(new StringPair("notify_url", u.notifyURL));
        p.add(new StringPair("return_url", u.returnURL));
        p.add(new StringPair("error_notify_url", u.errorNotifyURL));
        p.add(new StringPair("out_trade_no", tradeId));
        p.add(new StringPair("subject", subject));
        p.add(new StringPair("payment_type", "1"));
        p.add(new StringPair("total_fee", String.valueOf(total)));
        p.add(new StringPair("seller_id", this.config.getPartnerId()));
        if (this.preferRSA) {
            sign = this.signRSA(p);
            p.add(new StringPair("sign_type", "RSA"));
        } else {
            sign = this.signMD5(p);
            p.add(new StringPair("sign_type", "MD5"));
        }
        p.add(new StringPair("sign", sign));
        return p;
    }

    public List<StringPair> createNotifyVerify(String notifyId) {
        ArrayList<StringPair> p = new ArrayList<StringPair>();
        p.add(new StringPair("service", "notify_verify"));
        p.add(new StringPair("partner", this.config.getPartnerId()));
        p.add(new StringPair("_input_charset", "utf-8"));
        p.add(new StringPair("notify_id", notifyId));
        return p;
    }

    public boolean verify(Map<String, String> parameterMap) {
        ArrayList<StringPair> parameterList = new ArrayList<StringPair>();
        for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
            if ("sign".equalsIgnoreCase(entry.getKey()) || "sign_type".equalsIgnoreCase(entry.getKey())) continue;
            parameterList.add(new StringPair(entry.getKey(), entry.getValue()));
        }
        if (parameterMap.get("sign_type").equals("RSA")) {
            return this.verifyRSA(parameterMap.get("sign"), parameterList);
        }
        String sign = this.signMD5(parameterList);
        return parameterMap.get("sign").equals(sign);
    }

    public static class PCURLs {
        public String notifyURL;
        public String returnURL;
        public String errorNotifyURL;
    }
}

