/*
 * Decompiled with CFR 0.152.
 */
package net.sinofool.alipay.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.bind.DatatypeConverter;
import net.sinofool.alipay.AlipayConfig;
import net.sinofool.alipay.AlipayException;
import net.sinofool.alipay.base.GroupStringPair;
import net.sinofool.alipay.base.StringPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAlipay {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAlipay.class);
    private static final Charset CHARSET = Charset.forName("utf-8");
    protected AlipayConfig config;
    private final PrivateKey myPrivateKey;
    private final PublicKey alipayPublicKey;
    protected final boolean preferRSA;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    protected AbstractAlipay(AlipayConfig config) {
        this.config = config;
        this.myPrivateKey = this.initMyPrivateKey(config.getMyPrivateKey());
        this.alipayPublicKey = this.initAlipayPublicKey(config.getAlipayPublicKey());
        this.preferRSA = this.myPrivateKey != null && this.alipayPublicKey != null;
    }

    private PublicKey initAlipayPublicKey(String key) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            byte[] encodedKey = DatatypeConverter.parseBase64Binary((String)key);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            return pubKey;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Cannot initialzie RSA public key, fallback to md5", (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            LOG.warn("Cannot initialzie RSA public key, fallback to md5", (Throwable)e);
        }
        return null;
    }

    private PrivateKey initMyPrivateKey(String key) {
        try {
            byte[] keyBytes = DatatypeConverter.parseBase64Binary((String)key);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Cannot initialzie RSA private key, fallback to md5", (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            LOG.warn("Cannot initialzie RSA private key, fallback to md5", (Throwable)e);
        }
        return null;
    }

    protected String signMD5(List<StringPair> p) {
        String param = this.join(p, false);
        String sign = AbstractAlipay.md5Sign(param + this.config.getMD5KEY());
        LOG.trace("Signing {}", (Object)param);
        return sign;
    }

    protected String signRSA(List<StringPair> p) {
        String param = this.join(p, false);
        String sign = this.rsaSign(param);
        return sign;
    }

    protected boolean verifyRSA(String sign, List<StringPair> p) {
        String param = this.join(p, false);
        LOG.trace("verifyRSA sing={}", (Object)sign);
        LOG.trace("verifyRSA content={}" + param);
        return this.rsaVerify(param, sign);
    }

    protected boolean verifyMD5(String sign, List<StringPair> p) {
        return sign.equals(this.signMD5(p));
    }

    protected String join(List<StringPair> p, boolean encode) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < p.size(); ++i) {
            if (i != 0) {
                buff.append("&");
            }
            buff.append(p.get(i).getFirst()).append("=");
            if (encode) {
                try {
                    buff.append(URLEncoder.encode(p.get(i).getSecond(), "utf-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    LOG.warn("Cannot encode {}", (Object)p.get(i).getSecond());
                    throw new AlipayException(e);
                }
            }
            buff.append(p.get(i).getSecond());
        }
        return buff.toString();
    }

    private static String hex(byte[] input) {
        StringBuffer buf = new StringBuffer();
        for (int j = 0; j < input.length; ++j) {
            buf.append(DIGITS[input[j] >> 4 & 0xF]);
            buf.append(DIGITS[input[j] & 0xF]);
        }
        return buf.toString();
    }

    private static String md5Sign(String input) {
        try {
            byte[] digest = MessageDigest.getInstance("MD5").digest(input.getBytes(CHARSET));
            return AbstractAlipay.hex(digest);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Cannot find MD5 digest algorithm", (Throwable)e);
            throw new AlipayException(e);
        }
    }

    private String rsaSign(String content) {
        try {
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initSign(this.myPrivateKey);
            signature.update(content.getBytes(CHARSET));
            byte[] signed = signature.sign();
            return DatatypeConverter.printBase64Binary((byte[])signed);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Cannot sign content", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            LOG.warn("Cannot sign content", (Throwable)e);
        }
        catch (SignatureException e) {
            LOG.warn("Cannot sign content", (Throwable)e);
        }
        return null;
    }

    protected boolean rsaVerify(String content, String sign) {
        try {
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initVerify(this.alipayPublicKey);
            signature.update(content.getBytes(CHARSET));
            boolean bverify = signature.verify(DatatypeConverter.parseBase64Binary((String)sign));
            return bverify;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Cannot verify signature", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            LOG.warn("Cannot verify signature", (Throwable)e);
        }
        catch (SignatureException e) {
            LOG.warn("Cannot verify signature", (Throwable)e);
        }
        return false;
    }

    protected String decrypt(String content) {
        LOG.trace("decrypt content={}", (Object)content);
        try {
            int bufl;
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, this.myPrivateKey);
            ByteArrayInputStream ins = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)content));
            ByteArrayOutputStream writer = new ByteArrayOutputStream();
            byte[] buf = new byte[256];
            while ((bufl = ins.read(buf)) != -1) {
                byte[] block = null;
                if (buf.length == bufl) {
                    block = buf;
                } else {
                    block = new byte[bufl];
                    for (int i = 0; i < bufl; ++i) {
                        block[i] = buf[i];
                    }
                }
                writer.write(cipher.doFinal(block));
            }
            return new String(writer.toByteArray(), CHARSET);
        }
        catch (NoSuchPaddingException e) {
            LOG.warn("Cannot decrypt content", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            LOG.warn("Cannot decrypt content", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Cannot decrypt content", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            LOG.warn("Cannot decrypt content", (Throwable)e);
        }
        catch (BadPaddingException e) {
            LOG.warn("Cannot decrypt content", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn("Cannot decrypt content", (Throwable)e);
        }
        return null;
    }

    public GroupStringPair parseQueryString(String queryString) {
        try {
            return GroupStringPair.parseQueryString(queryString, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Error parsing query string", (Throwable)e);
            throw new AlipayException(e);
        }
    }

    public GroupStringPair parsePostBody(InputStream postBody) {
        try {
            return GroupStringPair.parsePostBody(postBody, "utf-8", "utf-8");
        }
        catch (IOException e) {
            LOG.warn("Error parsing post body", (Throwable)e);
            throw new AlipayException(e);
        }
    }
}

