/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.numberpicker;

import android.content.Context;
import android.util.FloatMath;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;

public class Scroller {
    private int mMode;
    private int mStartX;
    private int mStartY;
    private int mFinalX;
    private int mFinalY;
    private int mMinX;
    private int mMaxX;
    private int mMinY;
    private int mMaxY;
    private int mCurrX;
    private int mCurrY;
    private long mStartTime;
    private int mDuration;
    private float mDurationReciprocal;
    private float mDeltaX;
    private float mDeltaY;
    private boolean mFinished = true;
    private Interpolator mInterpolator;
    private boolean mFlywheel;
    private float mVelocity;
    private static final int DEFAULT_DURATION = 250;
    private static final int SCROLL_MODE = 0;
    private static final int FLING_MODE = 1;
    private static float DECELERATION_RATE = (float)(Math.log(0.75) / Math.log(0.9));
    private static float ALPHA = 800.0f;
    private static float START_TENSION = 0.4f;
    private static float END_TENSION = 1.0f - START_TENSION;
    private static final int NB_SAMPLES = 100;
    private static final float[] SPLINE = new float[101];
    private float mDeceleration;
    private final float mPpi;
    private static float sViscousFluidScale;
    private static float sViscousFluidNormalize;

    public Scroller(Context context) {
        this(context, null);
    }

    public Scroller(Context context, Interpolator interpolator) {
        this(context, interpolator, true);
    }

    public Scroller(Context context, Interpolator interpolator, boolean flywheel) {
        this.mInterpolator = interpolator;
        this.mPpi = context.getResources().getDisplayMetrics().density * 160.0f;
        this.mDeceleration = this.computeDeceleration(ViewConfiguration.getScrollFriction());
        this.mFlywheel = flywheel;
    }

    public final void setFriction(float friction) {
        this.mDeceleration = this.computeDeceleration(friction);
    }

    private float computeDeceleration(float friction) {
        return 386.0878f * this.mPpi * friction;
    }

    public final boolean isFinished() {
        return this.mFinished;
    }

    public final void forceFinished(boolean finished) {
        this.mFinished = finished;
    }

    public final int getDuration() {
        return this.mDuration;
    }

    public final int getCurrX() {
        return this.mCurrX;
    }

    public final int getCurrY() {
        return this.mCurrY;
    }

    public float getCurrVelocity() {
        return this.mVelocity - this.mDeceleration * (float)this.timePassed() / 2000.0f;
    }

    public final int getStartX() {
        return this.mStartX;
    }

    public final int getStartY() {
        return this.mStartY;
    }

    public final int getFinalX() {
        return this.mFinalX;
    }

    public final int getFinalY() {
        return this.mFinalY;
    }

    public boolean computeScrollOffset() {
        if (this.mFinished) {
            return false;
        }
        int timePassed = (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
        if (timePassed < this.mDuration) {
            switch (this.mMode) {
                case 0: {
                    float x = (float)timePassed * this.mDurationReciprocal;
                    x = this.mInterpolator == null ? Scroller.viscousFluid(x) : this.mInterpolator.getInterpolation(x);
                    this.mCurrX = this.mStartX + Math.round(x * this.mDeltaX);
                    this.mCurrY = this.mStartY + Math.round(x * this.mDeltaY);
                    break;
                }
                case 1: {
                    float t = (float)timePassed / (float)this.mDuration;
                    int index = (int)(100.0f * t);
                    float t_inf = (float)index / 100.0f;
                    float t_sup = (float)(index + 1) / 100.0f;
                    float d_inf = SPLINE[index];
                    float d_sup = SPLINE[index + 1];
                    float distanceCoef = d_inf + (t - t_inf) / (t_sup - t_inf) * (d_sup - d_inf);
                    this.mCurrX = this.mStartX + Math.round(distanceCoef * (float)(this.mFinalX - this.mStartX));
                    this.mCurrX = Math.min(this.mCurrX, this.mMaxX);
                    this.mCurrX = Math.max(this.mCurrX, this.mMinX);
                    this.mCurrY = this.mStartY + Math.round(distanceCoef * (float)(this.mFinalY - this.mStartY));
                    this.mCurrY = Math.min(this.mCurrY, this.mMaxY);
                    this.mCurrY = Math.max(this.mCurrY, this.mMinY);
                    if (this.mCurrX != this.mFinalX || this.mCurrY != this.mFinalY) break;
                    this.mFinished = true;
                }
            }
        } else {
            this.mCurrX = this.mFinalX;
            this.mCurrY = this.mFinalY;
            this.mFinished = true;
        }
        return true;
    }

    public void startScroll(int startX, int startY, int dx, int dy) {
        this.startScroll(startX, startY, dx, dy, 250);
    }

    public void startScroll(int startX, int startY, int dx, int dy, int duration) {
        this.mMode = 0;
        this.mFinished = false;
        this.mDuration = duration;
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mStartX = startX;
        this.mStartY = startY;
        this.mFinalX = startX + dx;
        this.mFinalY = startY + dy;
        this.mDeltaX = dx;
        this.mDeltaY = dy;
        this.mDurationReciprocal = 1.0f / (float)this.mDuration;
    }

    public void fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY) {
        float velocity;
        if (this.mFlywheel && !this.mFinished) {
            float oldVel = this.getCurrVelocity();
            float dx = this.mFinalX - this.mStartX;
            float dy = this.mFinalY - this.mStartY;
            float hyp = FloatMath.sqrt((float)(dx * dx + dy * dy));
            float ndx = dx / hyp;
            float ndy = dy / hyp;
            float oldVelocityX = ndx * oldVel;
            float oldVelocityY = ndy * oldVel;
            if (Math.signum(velocityX) == Math.signum(oldVelocityX) && Math.signum(velocityY) == Math.signum(oldVelocityY)) {
                velocityX = (int)((float)velocityX + oldVelocityX);
                velocityY = (int)((float)velocityY + oldVelocityY);
            }
        }
        this.mMode = 1;
        this.mFinished = false;
        this.mVelocity = velocity = FloatMath.sqrt((float)(velocityX * velocityX + velocityY * velocityY));
        double l = Math.log(START_TENSION * velocity / ALPHA);
        this.mDuration = (int)(1000.0 * Math.exp(l / ((double)DECELERATION_RATE - 1.0)));
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mStartX = startX;
        this.mStartY = startY;
        float coeffX = velocity == 0.0f ? 1.0f : (float)velocityX / velocity;
        float coeffY = velocity == 0.0f ? 1.0f : (float)velocityY / velocity;
        int totalDistance = (int)((double)ALPHA * Math.exp((double)DECELERATION_RATE / ((double)DECELERATION_RATE - 1.0) * l));
        this.mMinX = minX;
        this.mMaxX = maxX;
        this.mMinY = minY;
        this.mMaxY = maxY;
        this.mFinalX = startX + Math.round((float)totalDistance * coeffX);
        this.mFinalX = Math.min(this.mFinalX, this.mMaxX);
        this.mFinalX = Math.max(this.mFinalX, this.mMinX);
        this.mFinalY = startY + Math.round((float)totalDistance * coeffY);
        this.mFinalY = Math.min(this.mFinalY, this.mMaxY);
        this.mFinalY = Math.max(this.mFinalY, this.mMinY);
    }

    static float viscousFluid(float x) {
        if ((x *= sViscousFluidScale) < 1.0f) {
            x -= 1.0f - (float)Math.exp(-x);
        } else {
            float start = 0.36787945f;
            x = 1.0f - (float)Math.exp(1.0f - x);
            x = start + x * (1.0f - start);
        }
        return x *= sViscousFluidNormalize;
    }

    public void abortAnimation() {
        this.mCurrX = this.mFinalX;
        this.mCurrY = this.mFinalY;
        this.mFinished = true;
    }

    public void extendDuration(int extend) {
        int passed = this.timePassed();
        this.mDuration = passed + extend;
        this.mDurationReciprocal = 1.0f / (float)this.mDuration;
        this.mFinished = false;
    }

    public int timePassed() {
        return (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
    }

    public void setFinalX(int newX) {
        this.mFinalX = newX;
        this.mDeltaX = this.mFinalX - this.mStartX;
        this.mFinished = false;
    }

    public void setFinalY(int newY) {
        this.mFinalY = newY;
        this.mDeltaY = this.mFinalY - this.mStartY;
        this.mFinished = false;
    }

    public boolean isScrollingInDirection(float xvel, float yvel) {
        return !this.mFinished && Math.signum(xvel) == Math.signum(this.mFinalX - this.mStartX) && Math.signum(yvel) == Math.signum(this.mFinalY - this.mStartY);
    }

    static {
        float x_min = 0.0f;
        for (int i = 0; i <= 100; ++i) {
            float d;
            float x;
            float coef;
            float tx;
            float t = (float)i / 100.0f;
            float x_max = 1.0f;
            while (!((double)Math.abs((tx = (coef = 3.0f * (x = x_min + (x_max - x_min) / 2.0f) * (1.0f - x)) * ((1.0f - x) * START_TENSION + x * END_TENSION) + x * x * x) - t) < 1.0E-5)) {
                if (tx > t) {
                    x_max = x;
                    continue;
                }
                x_min = x;
            }
            Scroller.SPLINE[i] = d = coef + x * x * x;
        }
        Scroller.SPLINE[100] = 1.0f;
        sViscousFluidScale = 8.0f;
        sViscousFluidNormalize = 1.0f;
        sViscousFluidNormalize = 1.0f / Scroller.viscousFluid(1.0f);
    }
}

