/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer.samples;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SeekBar;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import net.simonvt.menudrawer.MenuDrawer;

public class ContentSample
extends Activity {
    private static final String STATE_ACTIVE_POSITION = "net.simonvt.menudrawer.samples.ContentSample.activePosition";
    private static final String STATE_CONTENT_TEXT = "net.simonvt.menudrawer.samples.ContentSample.contentText";
    private MenuDrawer mMenuDrawer;
    private MenuAdapter mAdapter;
    private ListView mList;
    private int mActivePosition = -1;
    private String mContentText;
    private TextView mContentTextView;
    private AdapterView.OnItemClickListener mItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            ContentSample.this.mActivePosition = position;
            ContentSample.this.mMenuDrawer.setActiveView(view, position);
            ContentSample.this.mContentTextView.setText(((TextView)view).getText());
            ContentSample.this.mMenuDrawer.closeMenu();
        }
    };

    protected void onCreate(Bundle inState) {
        super.onCreate(inState);
        if (inState != null) {
            this.mActivePosition = inState.getInt(STATE_ACTIVE_POSITION);
            this.mContentText = inState.getString(STATE_CONTENT_TEXT);
        }
        this.mMenuDrawer = MenuDrawer.attach((Activity)this, 0);
        this.mMenuDrawer.setContentView(2130903041);
        this.mMenuDrawer.setTouchMode(2);
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(new Item("Item 1", 2130837504));
        items.add(new Item("Item 2", 2130837505));
        items.add(new Category("Cat 1"));
        items.add(new Item("Item 3", 2130837504));
        items.add(new Item("Item 4", 2130837505));
        items.add(new Category("Cat 2"));
        items.add(new Item("Item 5", 2130837504));
        items.add(new Item("Item 6", 2130837505));
        items.add(new Category("Cat 3"));
        items.add(new Item("Item 7", 2130837504));
        items.add(new Item("Item 8", 2130837505));
        items.add(new Category("Cat 4"));
        items.add(new Item("Item 9", 2130837504));
        items.add(new Item("Item 10", 2130837505));
        this.mList = new ListView((Context)this);
        this.mAdapter = new MenuAdapter(items);
        this.mList.setAdapter((ListAdapter)this.mAdapter);
        this.mList.setOnItemClickListener(this.mItemClickListener);
        this.mMenuDrawer.setMenuView((View)this.mList);
        if (Build.VERSION.SDK_INT >= 14) {
            this.getActionBar().setDisplayHomeAsUpEnabled(true);
        }
        this.mContentTextView = (TextView)this.findViewById(2131034118);
        this.mContentTextView.setText((CharSequence)this.mContentText);
        this.mMenuDrawer.setOnInterceptMoveEventListener(new MenuDrawer.OnInterceptMoveEventListener(){

            @Override
            public boolean isViewDraggable(View v, int dx, int x, int y) {
                return v instanceof SeekBar;
            }
        });
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(STATE_ACTIVE_POSITION, this.mActivePosition);
        outState.putString(STATE_CONTENT_TEXT, this.mContentText);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.mMenuDrawer.toggleMenu();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        int drawerState = this.mMenuDrawer.getDrawerState();
        if (drawerState == 8 || drawerState == 4) {
            this.mMenuDrawer.closeMenu();
            return;
        }
        super.onBackPressed();
    }

    private class MenuAdapter
    extends BaseAdapter {
        private List<Object> mItems;

        MenuAdapter(List<Object> items) {
            this.mItems = items;
        }

        public int getCount() {
            return this.mItems.size();
        }

        public Object getItem(int position) {
            return this.mItems.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public int getItemViewType(int position) {
            return this.getItem(position) instanceof Item ? 0 : 1;
        }

        public int getViewTypeCount() {
            return 2;
        }

        public boolean isEnabled(int position) {
            return this.getItem(position) instanceof Item;
        }

        public boolean areAllItemsEnabled() {
            return false;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View v = convertView;
            Object item = this.getItem(position);
            if (item instanceof Category) {
                if (v == null) {
                    v = ContentSample.this.getLayoutInflater().inflate(2130903051, parent, false);
                }
                ((TextView)v).setText((CharSequence)((Category)item).mTitle);
            } else {
                if (v == null) {
                    v = ContentSample.this.getLayoutInflater().inflate(2130903052, parent, false);
                }
                TextView tv = (TextView)v;
                tv.setText((CharSequence)((Item)item).mTitle);
                tv.setCompoundDrawablesWithIntrinsicBounds(((Item)item).mIconRes, 0, 0, 0);
            }
            v.setTag(2131034117, (Object)position);
            if (position == ContentSample.this.mActivePosition) {
                ContentSample.this.mMenuDrawer.setActiveView(v, position);
            }
            return v;
        }
    }

    private static class Category {
        String mTitle;

        Category(String title) {
            this.mTitle = title;
        }
    }

    private static class Item {
        String mTitle;
        int mIconRes;

        Item(String title, int iconRes) {
            this.mTitle = title;
            this.mIconRes = iconRes;
        }
    }
}

