/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import net.simonvt.menudrawer.DraggableDrawer;

public abstract class VerticalDrawer
extends DraggableDrawer {
    VerticalDrawer(Activity activity, int dragMode) {
        super(activity, dragMode);
    }

    public VerticalDrawer(Context context) {
        super(context);
    }

    public VerticalDrawer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public VerticalDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (widthMode != 0x40000000 || heightMode != 0x40000000) {
            throw new IllegalStateException("Must measure with an exact size");
        }
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (!this.mMenuSizeSet) {
            this.mMenuSize = (int)((float)height * 0.25f);
        }
        if (this.mOffsetPixels == -1.0f) {
            this.openMenu(false);
        }
        int menuWidthMeasureSpec = VerticalDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)width);
        int menuHeightMeasureSpec = VerticalDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)this.mMenuSize);
        this.mMenuContainer.measure(menuWidthMeasureSpec, menuHeightMeasureSpec);
        int contentWidthMeasureSpec = VerticalDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)width);
        int contentHeightMeasureSpec = VerticalDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)height);
        this.mContentContainer.measure(contentWidthMeasureSpec, contentHeightMeasureSpec);
        this.setMeasuredDimension(width, height);
        this.updateTouchAreaSize();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction() & 0xFF;
        if (action == 0 && this.mMenuVisible && this.isCloseEnough()) {
            this.setOffsetPixels(0.0f);
            this.stopAnimation();
            this.endPeek();
            this.setDrawerState(0);
        }
        if (this.mMenuVisible && this.isContentTouch(ev)) {
            return true;
        }
        if (this.mTouchMode == 0) {
            return false;
        }
        if (action != 0 && this.mIsDragging) {
            return true;
        }
        switch (action) {
            case 0: {
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                boolean allowDrag = this.onDownAllowDrag(ev);
                if (!allowDrag) break;
                this.setDrawerState(this.mMenuVisible ? 8 : 0);
                this.stopAnimation();
                this.endPeek();
                this.mIsDragging = false;
                break;
            }
            case 2: {
                float x = ev.getX();
                float dx = x - this.mLastMotionX;
                float xDiff = Math.abs(dx);
                float y = ev.getY();
                float dy = y - this.mLastMotionY;
                float yDiff = Math.abs(dy);
                if (!(yDiff > (float)this.mTouchSlop) || !(yDiff > xDiff)) break;
                if (this.mOnInterceptMoveEventListener != null && this.mTouchMode == 2 && this.canChildScrollVertically((View)this.mContentContainer, false, (int)dx, (int)x, (int)y)) {
                    this.endDrag();
                    return false;
                }
                boolean allowDrag = this.onMoveAllowDrag(ev, dy);
                if (!allowDrag) break;
                this.setDrawerState(2);
                this.mIsDragging = true;
                this.mLastMotionX = x;
                this.mLastMotionY = y;
                break;
            }
            case 1: 
            case 3: {
                if (Math.abs(this.mOffsetPixels) > (float)(this.mMenuSize / 2)) {
                    this.openMenu();
                    break;
                }
                this.closeMenu();
            }
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        return this.mIsDragging;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mMenuVisible && !this.mIsDragging && this.mTouchMode == 0) {
            return false;
        }
        int action = ev.getAction() & 0xFF;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        switch (action) {
            case 0: {
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                boolean allowDrag = this.onDownAllowDrag(ev);
                if (!allowDrag) break;
                this.stopAnimation();
                this.endPeek();
                this.startLayerTranslation();
                break;
            }
            case 2: {
                if (!this.mIsDragging) {
                    boolean allowDrag;
                    float x = ev.getX();
                    float dx = x - this.mLastMotionX;
                    float xDiff = Math.abs(dx);
                    float y = ev.getY();
                    float dy = y - this.mLastMotionY;
                    float yDiff = Math.abs(dy);
                    if (yDiff > (float)this.mTouchSlop && yDiff > xDiff && (allowDrag = this.onMoveAllowDrag(ev, dy))) {
                        this.setDrawerState(2);
                        this.mIsDragging = true;
                        float f = this.mLastMotionY = y - this.mInitialMotionY > 0.0f ? this.mInitialMotionY + (float)this.mTouchSlop : this.mInitialMotionY - (float)this.mTouchSlop;
                    }
                }
                if (!this.mIsDragging) break;
                this.startLayerTranslation();
                float y = ev.getY();
                float dy = y - this.mLastMotionY;
                this.mLastMotionY = y;
                this.onMoveEvent(dy);
                break;
            }
            case 1: 
            case 3: {
                this.onUpEvent(ev);
            }
        }
        return true;
    }
}

