/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import net.simonvt.menudrawer.Position;
import net.simonvt.menudrawer.StaticDrawer;

public class TopStaticDrawer
extends StaticDrawer {
    private int mIndicatorLeft;

    TopStaticDrawer(Activity activity, int dragMode) {
        super(activity, dragMode);
    }

    public TopStaticDrawer(Context context) {
        super(context);
    }

    public TopStaticDrawer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TopStaticDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void initDrawer(Context context, AttributeSet attrs, int defStyle) {
        super.initDrawer(context, attrs, defStyle);
        this.mPosition = Position.TOP;
    }

    @Override
    public void setDropShadowColor(int color2) {
        int endColor = color2 & 0xFFFFFF;
        this.mDropShadowDrawable = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{color2, endColor});
        this.invalidate();
    }

    @Override
    protected void drawIndicator(Canvas canvas) {
        if (this.mActiveView != null && this.isViewDescendant(this.mActiveView)) {
            int pos;
            Integer position = (Integer)this.mActiveView.getTag(2131034117);
            int n = pos = position == null ? 0 : position;
            if (pos == this.mActivePosition) {
                int menuHeight = this.mMenuSize;
                int indicatorHeight = this.mActiveIndicator.getHeight();
                this.mActiveView.getDrawingRect(this.mActiveRect);
                this.offsetDescendantRectToMyCoords(this.mActiveView, this.mActiveRect);
                int indicatorWidth = this.mActiveIndicator.getWidth();
                int indicatorTop = menuHeight - indicatorHeight;
                if (this.mIndicatorAnimating) {
                    int finalLeft = this.mActiveRect.left + (this.mActiveRect.width() - indicatorWidth) / 2;
                    int startLeft = this.mIndicatorStartPos;
                    int diff = finalLeft - startLeft;
                    int startOffset = (int)((float)diff * this.mIndicatorOffset);
                    this.mIndicatorLeft = startLeft + startOffset;
                } else {
                    this.mIndicatorLeft = this.mActiveRect.left + (this.mActiveRect.width() - indicatorWidth) / 2;
                }
                canvas.save();
                canvas.clipRect(this.mIndicatorLeft, indicatorTop, this.mIndicatorLeft + indicatorWidth, menuHeight);
                canvas.drawBitmap(this.mActiveIndicator, (float)this.mIndicatorLeft, (float)indicatorTop, null);
                canvas.restore();
            }
        }
    }

    @Override
    protected int getIndicatorStartPos() {
        return this.mIndicatorLeft;
    }
}

