/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import net.simonvt.menudrawer.VerticalDrawer;

public class TopDrawer
extends VerticalDrawer {
    private int mIndicatorLeft;

    TopDrawer(Activity activity, int dragMode) {
        super(activity, dragMode);
    }

    public TopDrawer(Context context) {
        super(context);
    }

    public TopDrawer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TopDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public void openMenu(boolean animate) {
        this.animateOffsetTo(this.mMenuSize, 0, animate);
    }

    @Override
    public void closeMenu(boolean animate) {
        this.animateOffsetTo(0, 0, animate);
    }

    @Override
    public void setDropShadowColor(int color2) {
        int endColor = color2 & 0xFFFFFF;
        this.mDropShadowDrawable = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{color2, endColor});
        this.invalidate();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = r - l;
        int height = b - t;
        int offsetPixels = (int)this.mOffsetPixels;
        this.mMenuContainer.layout(0, 0, width, this.mMenuSize);
        this.offsetMenu(offsetPixels);
        if (USE_TRANSLATIONS) {
            this.mContentContainer.layout(0, 0, width, height);
        } else {
            this.mContentContainer.layout(0, offsetPixels, width, height + offsetPixels);
        }
    }

    private void offsetMenu(int offsetPixels) {
        if (this.mOffsetMenu && this.mMenuSize != 0) {
            int menuSize = this.mMenuSize;
            float openRatio = ((float)menuSize - (float)offsetPixels) / (float)menuSize;
            if (USE_TRANSLATIONS) {
                if (offsetPixels > 0) {
                    int offset = (int)(0.25f * (-openRatio * (float)menuSize));
                    this.mMenuContainer.setTranslationY(offset);
                } else {
                    this.mMenuContainer.setTranslationY(-menuSize);
                }
            } else {
                int oldMenuTop = this.mMenuContainer.getTop();
                int offset = (int)(0.25f * (-openRatio * (float)menuSize)) - oldMenuTop;
                this.mMenuContainer.offsetTopAndBottom(offset);
                this.mMenuContainer.setVisibility(offsetPixels == 0 ? 4 : 0);
            }
        }
    }

    @Override
    protected void drawDropShadow(Canvas canvas, int offsetPixels) {
        int width = this.getWidth();
        this.mDropShadowDrawable.setBounds(0, offsetPixels - this.mDropShadowSize, width, offsetPixels);
        this.mDropShadowDrawable.draw(canvas);
    }

    @Override
    protected void drawMenuOverlay(Canvas canvas, int offsetPixels) {
        int width = this.getWidth();
        float openRatio = (float)offsetPixels / (float)this.mMenuSize;
        this.mMenuOverlay.setBounds(0, 0, width, offsetPixels);
        this.mMenuOverlay.setAlpha((int)(185.0f * (1.0f - openRatio)));
        this.mMenuOverlay.draw(canvas);
    }

    @Override
    protected void drawIndicator(Canvas canvas, int offsetPixels) {
        if (this.mActiveView != null && this.isViewDescendant(this.mActiveView)) {
            int pos;
            Integer position = (Integer)this.mActiveView.getTag(2131034117);
            int n = pos = position == null ? 0 : position;
            if (pos == this.mActivePosition) {
                int menuHeight = this.mMenuSize;
                int indicatorHeight = this.mActiveIndicator.getHeight();
                float openRatio = (float)offsetPixels / (float)menuHeight;
                this.mActiveView.getDrawingRect(this.mActiveRect);
                this.offsetDescendantRectToMyCoords(this.mActiveView, this.mActiveRect);
                int indicatorWidth = this.mActiveIndicator.getWidth();
                float interpolatedRatio = 1.0f - INDICATOR_INTERPOLATOR.getInterpolation(1.0f - openRatio);
                int interpolatedHeight = (int)((float)indicatorHeight * interpolatedRatio);
                int indicatorTop = offsetPixels - interpolatedHeight;
                if (this.mIndicatorAnimating) {
                    int finalLeft = this.mActiveRect.left + (this.mActiveRect.width() - indicatorWidth) / 2;
                    int startLeft = this.mIndicatorStartPos;
                    int diff = finalLeft - startLeft;
                    int startOffset = (int)((float)diff * this.mIndicatorOffset);
                    this.mIndicatorLeft = startLeft + startOffset;
                } else {
                    this.mIndicatorLeft = this.mActiveRect.left + (this.mActiveRect.width() - indicatorWidth) / 2;
                }
                canvas.save();
                canvas.clipRect(this.mIndicatorLeft, indicatorTop, this.mIndicatorLeft + indicatorWidth, offsetPixels);
                canvas.drawBitmap(this.mActiveIndicator, (float)this.mIndicatorLeft, (float)indicatorTop, null);
                canvas.restore();
            }
        }
    }

    @Override
    protected int getIndicatorStartPos() {
        return this.mIndicatorLeft;
    }

    @Override
    protected void initPeekScroller() {
        int dx = this.mMenuSize / 3;
        this.mPeekScroller.startScroll(0, 0, dx, 0, 5000);
    }

    @Override
    protected void onOffsetPixelsChanged(int offsetPixels) {
        if (USE_TRANSLATIONS) {
            this.mContentContainer.setTranslationY(offsetPixels);
            this.offsetMenu(offsetPixels);
            this.invalidate();
        } else {
            this.mContentContainer.offsetTopAndBottom(offsetPixels - this.mContentContainer.getTop());
            this.offsetMenu(offsetPixels);
            this.invalidate();
        }
    }

    @Override
    protected boolean isContentTouch(MotionEvent ev) {
        return ev.getY() > this.mOffsetPixels;
    }

    @Override
    protected boolean onDownAllowDrag(MotionEvent ev) {
        return !this.mMenuVisible && this.mInitialMotionY <= (float)this.mTouchSize || this.mMenuVisible && this.mInitialMotionY >= this.mOffsetPixels;
    }

    @Override
    protected boolean onMoveAllowDrag(MotionEvent ev, float diff) {
        return !this.mMenuVisible && this.mInitialMotionY <= (float)this.mTouchSize && diff > 0.0f || this.mMenuVisible && this.mInitialMotionY >= this.mOffsetPixels;
    }

    @Override
    protected void onMoveEvent(float dx) {
        this.setOffsetPixels(Math.min(Math.max(this.mOffsetPixels + dx, 0.0f), (float)this.mMenuSize));
    }

    @Override
    protected void onUpEvent(MotionEvent ev) {
        int offsetPixels = (int)this.mOffsetPixels;
        if (this.mIsDragging) {
            this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
            int initialVelocity = (int)this.mVelocityTracker.getXVelocity();
            this.mLastMotionY = ev.getY();
            this.animateOffsetTo(this.mVelocityTracker.getYVelocity() > 0.0f ? this.mMenuSize : 0, initialVelocity, true);
        } else if (this.mMenuVisible && ev.getY() > (float)offsetPixels) {
            this.closeMenu();
        }
    }
}

