/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import net.simonvt.menudrawer.MenuDrawer;
import net.simonvt.menudrawer.Position;

public abstract class StaticDrawer
extends MenuDrawer {
    protected Position mPosition;

    StaticDrawer(Activity activity, int dragMode) {
        super(activity, dragMode);
    }

    public StaticDrawer(Context context) {
        super(context);
    }

    public StaticDrawer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public StaticDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mDropShadowEnabled) {
            this.drawDropShadow(canvas);
        }
        if (this.mActiveIndicator != null) {
            this.drawIndicator(canvas);
        }
    }

    private void drawDropShadow(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        int menuSize = this.mMenuSize;
        int dropShadowSize = this.mDropShadowSize;
        switch (this.mPosition) {
            case LEFT: {
                this.mDropShadowDrawable.setBounds(menuSize - dropShadowSize, 0, menuSize, height);
                break;
            }
            case TOP: {
                this.mDropShadowDrawable.setBounds(0, menuSize - dropShadowSize, width, menuSize);
                break;
            }
            case RIGHT: {
                this.mDropShadowDrawable.setBounds(width - menuSize, 0, width - menuSize + dropShadowSize, height);
                break;
            }
            case BOTTOM: {
                this.mDropShadowDrawable.setBounds(0, height - menuSize, width, height - menuSize + dropShadowSize);
            }
        }
        this.mDropShadowDrawable.draw(canvas);
    }

    protected abstract void drawIndicator(Canvas var1);

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = r - l;
        int height = b - t;
        switch (this.mPosition) {
            case LEFT: {
                this.mMenuContainer.layout(0, 0, this.mMenuSize, height);
                this.mContentContainer.layout(this.mMenuSize, 0, width, height);
                break;
            }
            case RIGHT: {
                this.mMenuContainer.layout(width - this.mMenuSize, 0, width, height);
                this.mContentContainer.layout(0, 0, width - this.mMenuSize, height);
                break;
            }
            case TOP: {
                this.mMenuContainer.layout(0, 0, width, this.mMenuSize);
                this.mContentContainer.layout(0, this.mMenuSize, width, height);
                break;
            }
            case BOTTOM: {
                this.mMenuContainer.layout(0, height - this.mMenuSize, width, height);
                this.mContentContainer.layout(0, 0, width, height - this.mMenuSize);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (widthMode != 0x40000000 || heightMode != 0x40000000) {
            throw new IllegalStateException("Must measure with an exact size");
        }
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (!this.mMenuSizeSet) {
            this.mMenuSize = (int)((float)height * 0.25f);
        }
        switch (this.mPosition) {
            case LEFT: 
            case RIGHT: {
                int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
                int menuWidth = this.mMenuSize;
                int menuWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)menuWidth, (int)0x40000000);
                int contentWidth = width - menuWidth;
                int contentWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)contentWidth, (int)0x40000000);
                this.mContentContainer.measure(contentWidthMeasureSpec, childHeightMeasureSpec);
                this.mMenuContainer.measure(menuWidthMeasureSpec, childHeightMeasureSpec);
                break;
            }
            case TOP: 
            case BOTTOM: {
                int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
                int menuHeight = this.mMenuSize;
                int menuHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)menuHeight, (int)0x40000000);
                int contentHeight = height - menuHeight;
                int contentHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)contentHeight, (int)0x40000000);
                this.mContentContainer.measure(childWidthMeasureSpec, contentHeightMeasureSpec);
                this.mMenuContainer.measure(childWidthMeasureSpec, menuHeightMeasureSpec);
                break;
            }
        }
        this.setMeasuredDimension(width, height);
    }

    @Override
    public void toggleMenu(boolean animate) {
    }

    @Override
    public void openMenu(boolean animate) {
    }

    @Override
    public void closeMenu(boolean animate) {
    }

    @Override
    public boolean isMenuVisible() {
        return true;
    }

    @Override
    public void setMenuSize(int size) {
        this.mMenuSize = size;
        this.mMenuSizeSet = true;
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void setOffsetMenuEnabled(boolean offsetMenu) {
    }

    @Override
    public boolean getOffsetMenuEnabled() {
        return false;
    }

    @Override
    public void peekDrawer() {
    }

    @Override
    public void peekDrawer(long delay) {
    }

    @Override
    public void peekDrawer(long startDelay, long delay) {
    }

    @Override
    public void setHardwareLayerEnabled(boolean enabled) {
    }

    @Override
    public int getTouchMode() {
        return 0;
    }

    @Override
    public void setTouchMode(int mode) {
    }

    @Override
    public void setTouchBezelSize(int size) {
    }

    @Override
    public int getTouchBezelSize() {
        return 0;
    }
}

