/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import net.simonvt.menudrawer.Position;
import net.simonvt.menudrawer.StaticDrawer;

public class RightStaticDrawer
extends StaticDrawer {
    private int mIndicatorTop;

    RightStaticDrawer(Activity activity, int dragMode) {
        super(activity, dragMode);
    }

    public RightStaticDrawer(Context context) {
        super(context);
    }

    public RightStaticDrawer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RightStaticDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void initDrawer(Context context, AttributeSet attrs, int defStyle) {
        super.initDrawer(context, attrs, defStyle);
        this.mPosition = Position.RIGHT;
    }

    @Override
    public void setDropShadowColor(int color2) {
        int endColor = color2 & 0xFFFFFF;
        this.mDropShadowDrawable = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, new int[]{color2, endColor});
        this.invalidate();
    }

    @Override
    protected void drawIndicator(Canvas canvas) {
        if (this.mActiveView != null && this.isViewDescendant(this.mActiveView)) {
            int pos;
            Integer position = (Integer)this.mActiveView.getTag(2131034117);
            int n = pos = position == null ? 0 : position;
            if (pos == this.mActivePosition) {
                int width = this.getWidth();
                int menuWidth = this.mMenuSize;
                int indicatorWidth = this.mActiveIndicator.getWidth();
                int contentRight = width - menuWidth;
                this.mActiveView.getDrawingRect(this.mActiveRect);
                this.offsetDescendantRectToMyCoords(this.mActiveView, this.mActiveRect);
                int indicatorRight = contentRight + indicatorWidth;
                int indicatorLeft = contentRight;
                if (this.mIndicatorAnimating) {
                    int indicatorFinalTop = this.mActiveRect.top + (this.mActiveRect.height() - this.mActiveIndicator.getHeight()) / 2;
                    int indicatorStartTop = this.mIndicatorStartPos;
                    int diff = indicatorFinalTop - indicatorStartTop;
                    int startOffset = (int)((float)diff * this.mIndicatorOffset);
                    this.mIndicatorTop = indicatorStartTop + startOffset;
                } else {
                    this.mIndicatorTop = this.mActiveRect.top + (this.mActiveRect.height() - this.mActiveIndicator.getHeight()) / 2;
                }
                canvas.save();
                canvas.clipRect(contentRight, 0, indicatorRight, this.getHeight());
                canvas.drawBitmap(this.mActiveIndicator, (float)indicatorLeft, (float)this.mIndicatorTop, null);
                canvas.restore();
            }
        }
    }

    @Override
    protected int getIndicatorStartPos() {
        return this.mIndicatorTop;
    }
}

