/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import net.simonvt.menudrawer.HorizontalDrawer;

public class RightDrawer
extends HorizontalDrawer {
    private int mIndicatorTop;

    RightDrawer(Activity activity, int dragMode) {
        super(activity, dragMode);
    }

    public RightDrawer(Context context) {
        super(context);
    }

    public RightDrawer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RightDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public void openMenu(boolean animate) {
        this.animateOffsetTo(-this.mMenuSize, 0, animate);
    }

    @Override
    public void closeMenu(boolean animate) {
        this.animateOffsetTo(0, 0, animate);
    }

    @Override
    public void setDropShadowColor(int color2) {
        int endColor = color2 & 0xFFFFFF;
        this.mDropShadowDrawable = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, new int[]{color2, endColor});
        this.invalidate();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = r - l;
        int height = b - t;
        int offsetPixels = (int)this.mOffsetPixels;
        this.mMenuContainer.layout(width - this.mMenuSize, 0, width, height);
        this.offsetMenu(offsetPixels);
        if (USE_TRANSLATIONS) {
            this.mContentContainer.layout(0, 0, width, height);
        } else {
            this.mContentContainer.layout(offsetPixels, 0, width + offsetPixels, height);
        }
    }

    private void offsetMenu(int offsetPixels) {
        if (this.mOffsetMenu && this.mMenuSize != 0) {
            int menuWidth = this.mMenuSize;
            float openRatio = ((float)menuWidth + (float)offsetPixels) / (float)menuWidth;
            if (USE_TRANSLATIONS) {
                if (offsetPixels != 0) {
                    int offset = (int)(0.25f * (openRatio * (float)menuWidth));
                    this.mMenuContainer.setTranslationX(offset);
                } else {
                    this.mMenuContainer.setTranslationX(-menuWidth);
                }
            } else {
                int width = this.getWidth();
                int oldMenuRight = this.mMenuContainer.getRight();
                int newRight = width + (int)(0.25f * (openRatio * (float)menuWidth));
                int offset = newRight - oldMenuRight;
                this.mMenuContainer.offsetLeftAndRight(offset);
                this.mMenuContainer.setVisibility(offsetPixels == 0 ? 4 : 0);
            }
        }
    }

    @Override
    protected void drawDropShadow(Canvas canvas, int offsetPixels) {
        int height = this.getHeight();
        int width = this.getWidth();
        int left = width + offsetPixels;
        int right = left + this.mDropShadowSize;
        this.mDropShadowDrawable.setBounds(left, 0, right, height);
        this.mDropShadowDrawable.draw(canvas);
    }

    @Override
    protected void drawMenuOverlay(Canvas canvas, int offsetPixels) {
        int height = this.getHeight();
        int width = this.getWidth();
        int left = width + offsetPixels;
        int right = width;
        float openRatio = (float)Math.abs(offsetPixels) / (float)this.mMenuSize;
        this.mMenuOverlay.setBounds(left, 0, right, height);
        this.mMenuOverlay.setAlpha((int)(185.0f * (1.0f - openRatio)));
        this.mMenuOverlay.draw(canvas);
    }

    @Override
    protected void drawIndicator(Canvas canvas, int offsetPixels) {
        if (this.mActiveView != null && this.isViewDescendant(this.mActiveView)) {
            int pos;
            Integer position = (Integer)this.mActiveView.getTag(2131034117);
            int n = pos = position == null ? 0 : position;
            if (pos == this.mActivePosition) {
                int width = this.getWidth();
                int menuWidth = this.mMenuSize;
                int indicatorWidth = this.mActiveIndicator.getWidth();
                int contentRight = width + offsetPixels;
                float openRatio = (float)Math.abs(offsetPixels) / (float)menuWidth;
                this.mActiveView.getDrawingRect(this.mActiveRect);
                this.offsetDescendantRectToMyCoords(this.mActiveView, this.mActiveRect);
                float interpolatedRatio = 1.0f - INDICATOR_INTERPOLATOR.getInterpolation(1.0f - openRatio);
                int interpolatedWidth = (int)((float)indicatorWidth * interpolatedRatio);
                int indicatorRight = contentRight + interpolatedWidth;
                int indicatorLeft = indicatorRight - indicatorWidth;
                if (this.mIndicatorAnimating) {
                    int indicatorFinalTop = this.mActiveRect.top + (this.mActiveRect.height() - this.mActiveIndicator.getHeight()) / 2;
                    int indicatorStartTop = this.mIndicatorStartPos;
                    int diff = indicatorFinalTop - indicatorStartTop;
                    int startOffset = (int)((float)diff * this.mIndicatorOffset);
                    this.mIndicatorTop = indicatorStartTop + startOffset;
                } else {
                    this.mIndicatorTop = this.mActiveRect.top + (this.mActiveRect.height() - this.mActiveIndicator.getHeight()) / 2;
                }
                canvas.save();
                canvas.clipRect(contentRight, 0, indicatorRight, this.getHeight());
                canvas.drawBitmap(this.mActiveIndicator, (float)indicatorLeft, (float)this.mIndicatorTop, null);
                canvas.restore();
            }
        }
    }

    @Override
    protected int getIndicatorStartPos() {
        return this.mIndicatorTop;
    }

    @Override
    protected void initPeekScroller() {
        int dx = -this.mMenuSize / 3;
        this.mPeekScroller.startScroll(0, 0, dx, 0, 5000);
    }

    @Override
    protected void onOffsetPixelsChanged(int offsetPixels) {
        if (USE_TRANSLATIONS) {
            this.mContentContainer.setTranslationX(offsetPixels);
            this.offsetMenu(offsetPixels);
            this.invalidate();
        } else {
            this.mContentContainer.offsetLeftAndRight(offsetPixels - this.mContentContainer.getLeft());
            this.offsetMenu(offsetPixels);
            this.invalidate();
        }
    }

    @Override
    protected boolean isContentTouch(MotionEvent ev) {
        return ev.getX() < (float)this.getWidth() + this.mOffsetPixels;
    }

    @Override
    protected boolean onDownAllowDrag(MotionEvent ev) {
        int width = this.getWidth();
        int initialMotionX = (int)this.mInitialMotionX;
        return !this.mMenuVisible && initialMotionX >= width - this.mTouchSize || this.mMenuVisible && (float)initialMotionX <= (float)width + this.mOffsetPixels;
    }

    @Override
    protected boolean onMoveAllowDrag(MotionEvent ev, float diff) {
        int width = this.getWidth();
        int initialMotionX = (int)this.mInitialMotionX;
        return !this.mMenuVisible && initialMotionX >= width - this.mTouchSize && diff < 0.0f || this.mMenuVisible && (float)initialMotionX <= (float)width + this.mOffsetPixels;
    }

    @Override
    protected void onMoveEvent(float dx) {
        float newOffset = Math.max(Math.min(this.mOffsetPixels + dx, 0.0f), (float)(-this.mMenuSize));
        this.setOffsetPixels(newOffset);
    }

    @Override
    protected void onUpEvent(MotionEvent ev) {
        int offsetPixels = (int)this.mOffsetPixels;
        int width = this.getWidth();
        if (this.mIsDragging) {
            this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
            int initialVelocity = (int)this.mVelocityTracker.getXVelocity();
            this.mLastMotionX = ev.getX();
            this.animateOffsetTo(this.mVelocityTracker.getXVelocity() > 0.0f ? 0 : -this.mMenuSize, initialVelocity, true);
        } else if (this.mMenuVisible && ev.getX() < (float)(width + offsetPixels)) {
            this.closeMenu();
        }
    }
}

