/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;
import net.simonvt.menudrawer.BottomDrawer;
import net.simonvt.menudrawer.BottomStaticDrawer;
import net.simonvt.menudrawer.BuildLayerFrameLayout;
import net.simonvt.menudrawer.ColorDrawable;
import net.simonvt.menudrawer.FloatScroller;
import net.simonvt.menudrawer.LeftDrawer;
import net.simonvt.menudrawer.LeftStaticDrawer;
import net.simonvt.menudrawer.NoClickThroughFrameLayout;
import net.simonvt.menudrawer.Position;
import net.simonvt.menudrawer.R;
import net.simonvt.menudrawer.RightDrawer;
import net.simonvt.menudrawer.RightStaticDrawer;
import net.simonvt.menudrawer.SmoothInterpolator;
import net.simonvt.menudrawer.TopDrawer;
import net.simonvt.menudrawer.TopStaticDrawer;

public abstract class MenuDrawer
extends ViewGroup {
    private static final String TAG = "MenuDrawer";
    private static final boolean DEBUG = false;
    protected static final int ANIMATION_DELAY = 16;
    private static final int DEFAULT_DRAG_BEZEL_DP = 24;
    private static final int DEFAULT_DROP_SHADOW_DP = 6;
    public static final int MENU_DRAG_CONTENT = 0;
    public static final int MENU_DRAG_WINDOW = 1;
    public static final int TOUCH_MODE_NONE = 0;
    public static final int TOUCH_MODE_BEZEL = 1;
    public static final int TOUCH_MODE_FULLSCREEN = 2;
    public static final int STATE_CLOSED = 0;
    public static final int STATE_CLOSING = 1;
    public static final int STATE_DRAGGING = 2;
    public static final int STATE_OPENING = 4;
    public static final int STATE_OPEN = 8;
    static final boolean USE_TRANSLATIONS = Build.VERSION.SDK_INT >= 12;
    static final int INDICATOR_ANIM_DURATION = 800;
    private static final int DEFAULT_ANIMATION_DURATION = 600;
    protected static final Interpolator SMOOTH_INTERPOLATOR = new SmoothInterpolator();
    protected Drawable mMenuOverlay;
    protected boolean mDropShadowEnabled;
    protected Drawable mDropShadowDrawable;
    protected int mDropShadowSize;
    protected Bitmap mActiveIndicator;
    protected View mActiveView;
    protected int mActivePosition;
    private boolean mAllowIndicatorAnimation;
    protected final Rect mActiveRect = new Rect();
    private final Rect mTempRect = new Rect();
    private View mMenuView;
    protected BuildLayerFrameLayout mMenuContainer;
    protected BuildLayerFrameLayout mContentContainer;
    protected int mMenuSize;
    protected boolean mMenuSizeSet;
    protected boolean mMenuVisible;
    private int mDragMode = 0;
    protected int mDrawerState = 0;
    protected int mTouchBezelSize;
    protected int mTouchSize;
    private OnDrawerStateChangeListener mOnDrawerStateChangeListener;
    protected int mTouchMode = 1;
    protected boolean mHardwareLayersEnabled = true;
    private Activity mActivity;
    private FloatScroller mIndicatorScroller;
    private Runnable mIndicatorRunnable = new Runnable(){

        @Override
        public void run() {
            MenuDrawer.this.animateIndicatorInvalidate();
        }
    };
    protected int mIndicatorStartPos;
    protected float mIndicatorOffset;
    protected boolean mIndicatorAnimating;
    protected Bundle mState;
    protected int mMaxAnimationDuration = 600;
    protected OnInterceptMoveEventListener mOnInterceptMoveEventListener;
    private ViewTreeObserver.OnScrollChangedListener mScrollListener = new ViewTreeObserver.OnScrollChangedListener(){

        public void onScrollChanged() {
            if (MenuDrawer.this.mActiveView != null && MenuDrawer.this.isViewDescendant(MenuDrawer.this.mActiveView)) {
                MenuDrawer.this.mActiveView.getDrawingRect(MenuDrawer.this.mTempRect);
                MenuDrawer.this.offsetDescendantRectToMyCoords(MenuDrawer.this.mActiveView, MenuDrawer.this.mTempRect);
                if (((MenuDrawer)MenuDrawer.this).mTempRect.left != MenuDrawer.this.mActiveRect.left || ((MenuDrawer)MenuDrawer.this).mTempRect.top != MenuDrawer.this.mActiveRect.top || ((MenuDrawer)MenuDrawer.this).mTempRect.right != MenuDrawer.this.mActiveRect.right || ((MenuDrawer)MenuDrawer.this).mTempRect.bottom != MenuDrawer.this.mActiveRect.bottom) {
                    MenuDrawer.this.invalidate();
                }
            }
        }
    };

    public static MenuDrawer attach(Activity activity) {
        return MenuDrawer.attach(activity, 0);
    }

    public static MenuDrawer attach(Activity activity, int dragMode) {
        return MenuDrawer.attach(activity, dragMode, Position.LEFT);
    }

    public static MenuDrawer attach(Activity activity, Position position) {
        return MenuDrawer.attach(activity, 0, position);
    }

    public static MenuDrawer attach(Activity activity, int dragMode, Position position) {
        return MenuDrawer.attach(activity, dragMode, position, false);
    }

    public static MenuDrawer attach(Activity activity, int dragMode, Position position, boolean attachStatic) {
        MenuDrawer menuDrawer = MenuDrawer.createMenuDrawer(activity, dragMode, position, attachStatic);
        menuDrawer.setId(2131034116);
        switch (dragMode) {
            case 0: {
                MenuDrawer.attachToContent(activity, menuDrawer);
                break;
            }
            case 1: {
                MenuDrawer.attachToDecor(activity, menuDrawer);
                break;
            }
            default: {
                throw new RuntimeException("Unknown menu mode: " + dragMode);
            }
        }
        return menuDrawer;
    }

    private static MenuDrawer createMenuDrawer(Activity activity, int dragMode, Position position, boolean attachStatic) {
        if (attachStatic) {
            switch (position) {
                case LEFT: {
                    return new LeftStaticDrawer(activity, dragMode);
                }
                case RIGHT: {
                    return new RightStaticDrawer(activity, dragMode);
                }
                case TOP: {
                    return new TopStaticDrawer(activity, dragMode);
                }
                case BOTTOM: {
                    return new BottomStaticDrawer(activity, dragMode);
                }
            }
            throw new IllegalArgumentException("position must be one of LEFT, TOP, RIGHT or BOTTOM");
        }
        switch (position) {
            case LEFT: {
                return new LeftDrawer(activity, dragMode);
            }
            case RIGHT: {
                return new RightDrawer(activity, dragMode);
            }
            case TOP: {
                return new TopDrawer(activity, dragMode);
            }
            case BOTTOM: {
                return new BottomDrawer(activity, dragMode);
            }
        }
        throw new IllegalArgumentException("position must be one of LEFT, TOP, RIGHT or BOTTOM");
    }

    private static void attachToContent(Activity activity, MenuDrawer menuDrawer) {
        ViewGroup content = (ViewGroup)activity.findViewById(0x1020002);
        content.removeAllViews();
        content.addView((View)menuDrawer, -1, -1);
    }

    private static void attachToDecor(Activity activity, MenuDrawer menuDrawer) {
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        ViewGroup decorChild = (ViewGroup)decorView.getChildAt(0);
        decorView.removeAllViews();
        decorView.addView((View)menuDrawer, -1, -1);
        menuDrawer.mContentContainer.addView((View)decorChild, decorChild.getLayoutParams());
    }

    MenuDrawer(Activity activity, int dragMode) {
        this((Context)activity);
        this.mActivity = activity;
        this.mDragMode = dragMode;
    }

    public MenuDrawer(Context context) {
        this(context, null);
    }

    public MenuDrawer(Context context, AttributeSet attrs) {
        this(context, attrs, 2130771968);
    }

    public MenuDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initDrawer(context, attrs, defStyle);
    }

    protected void initDrawer(Context context, AttributeSet attrs, int defStyle) {
        this.setWillNotDraw(false);
        this.setFocusable(false);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MenuDrawer, 2130771968, 2131099649);
        Drawable contentBackground = a.getDrawable(0);
        Drawable menuBackground = a.getDrawable(1);
        this.mMenuSize = a.getDimensionPixelSize(2, -1);
        this.mMenuSizeSet = this.mMenuSize != -1;
        int indicatorResId = a.getResourceId(3, 0);
        if (indicatorResId != 0) {
            this.mActiveIndicator = BitmapFactory.decodeResource((Resources)this.getResources(), (int)indicatorResId);
        }
        this.mDropShadowEnabled = a.getBoolean(4, true);
        this.mDropShadowDrawable = a.getDrawable(7);
        if (this.mDropShadowDrawable == null) {
            int dropShadowColor = a.getColor(6, -16777216);
            this.setDropShadowColor(dropShadowColor);
        }
        this.mDropShadowSize = a.getDimensionPixelSize(5, this.dpToPx(6));
        this.mTouchBezelSize = a.getDimensionPixelSize(8, this.dpToPx(24));
        this.mAllowIndicatorAnimation = a.getBoolean(9, false);
        this.mMaxAnimationDuration = a.getInt(10, 600);
        a.recycle();
        this.mMenuContainer = new BuildLayerFrameLayout(context);
        this.mMenuContainer.setId(2131034115);
        this.mMenuContainer.setBackgroundDrawable(menuBackground);
        super.addView((View)this.mMenuContainer, -1, new ViewGroup.LayoutParams(-1, -1));
        this.mContentContainer = new NoClickThroughFrameLayout(context);
        this.mContentContainer.setId(2131034114);
        this.mContentContainer.setBackgroundDrawable(contentBackground);
        super.addView((View)this.mContentContainer, -1, new ViewGroup.LayoutParams(-1, -1));
        this.mMenuOverlay = new ColorDrawable(-16777216);
        this.mIndicatorScroller = new FloatScroller(SMOOTH_INTERPOLATOR);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        int childCount = this.mMenuContainer.getChildCount();
        if (childCount == 0) {
            this.mMenuContainer.addView(child, index, params);
            return;
        }
        childCount = this.mContentContainer.getChildCount();
        if (childCount == 0) {
            this.mContentContainer.addView(child, index, params);
            return;
        }
        throw new IllegalStateException("MenuDrawer can only hold two child views");
    }

    protected int dpToPx(int dp) {
        return (int)(this.getResources().getDisplayMetrics().density * (float)dp + 0.5f);
    }

    protected boolean isViewDescendant(View v) {
        for (ViewParent parent = v.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != this) continue;
            return true;
        }
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnScrollChangedListener(this.mScrollListener);
    }

    protected void onDetachedFromWindow() {
        this.getViewTreeObserver().removeOnScrollChangedListener(this.mScrollListener);
        super.onDetachedFromWindow();
    }

    public void toggleMenu() {
        this.toggleMenu(true);
    }

    public abstract void toggleMenu(boolean var1);

    public void openMenu() {
        this.openMenu(true);
    }

    public abstract void openMenu(boolean var1);

    public void closeMenu() {
        this.closeMenu(true);
    }

    public abstract void closeMenu(boolean var1);

    public abstract boolean isMenuVisible();

    public abstract void setMenuSize(int var1);

    public int getMenuSize() {
        return this.mMenuSize;
    }

    public void setActiveView(View v) {
        this.setActiveView(v, 0);
    }

    public void setActiveView(View v, int position) {
        View oldView = this.mActiveView;
        this.mActiveView = v;
        this.mActivePosition = position;
        if (this.mAllowIndicatorAnimation && oldView != null) {
            this.startAnimatingIndicator();
        }
        this.invalidate();
    }

    public void setAllowIndicatorAnimation(boolean animate) {
        if (animate != this.mAllowIndicatorAnimation) {
            this.mAllowIndicatorAnimation = animate;
            this.completeAnimatingIndicator();
        }
    }

    public boolean getAllowIndicatorAnimation() {
        return this.mAllowIndicatorAnimation;
    }

    private void startAnimatingIndicator() {
        this.mIndicatorStartPos = this.getIndicatorStartPos();
        this.mIndicatorAnimating = true;
        this.mIndicatorScroller.startScroll(0.0f, 1.0f, 800);
        this.animateIndicatorInvalidate();
    }

    protected abstract int getIndicatorStartPos();

    private void animateIndicatorInvalidate() {
        if (this.mIndicatorScroller.computeScrollOffset()) {
            this.mIndicatorOffset = this.mIndicatorScroller.getCurr();
            this.invalidate();
            if (!this.mIndicatorScroller.isFinished()) {
                this.postOnAnimation(this.mIndicatorRunnable);
                return;
            }
        }
        this.completeAnimatingIndicator();
    }

    private void completeAnimatingIndicator() {
        this.mIndicatorOffset = 1.0f;
        this.mIndicatorAnimating = false;
        this.invalidate();
    }

    public abstract void setOffsetMenuEnabled(boolean var1);

    public abstract boolean getOffsetMenuEnabled();

    public int getDrawerState() {
        return this.mDrawerState;
    }

    public void setOnDrawerStateChangeListener(OnDrawerStateChangeListener listener) {
        this.mOnDrawerStateChangeListener = listener;
    }

    public void setOnInterceptMoveEventListener(OnInterceptMoveEventListener listener) {
        this.mOnInterceptMoveEventListener = listener;
    }

    public void setDropShadowEnabled(boolean enabled) {
        this.mDropShadowEnabled = enabled;
        this.invalidate();
    }

    public abstract void setDropShadowColor(int var1);

    public void setDropShadow(Drawable drawable2) {
        this.mDropShadowDrawable = drawable2;
        this.invalidate();
    }

    public void setDropShadow(int resId) {
        this.setDropShadow(this.getResources().getDrawable(resId));
    }

    public Drawable getDropShadow() {
        return this.mDropShadowDrawable;
    }

    public void setDropShadowSize(int size) {
        this.mDropShadowSize = size;
        this.invalidate();
    }

    public abstract void peekDrawer();

    public abstract void peekDrawer(long var1);

    public abstract void peekDrawer(long var1, long var3);

    public abstract void setHardwareLayerEnabled(boolean var1);

    public void setMaxAnimationDuration(int duration) {
        this.mMaxAnimationDuration = duration;
    }

    public ViewGroup getMenuContainer() {
        return this.mMenuContainer;
    }

    public ViewGroup getContentContainer() {
        if (this.mDragMode == 0) {
            return this.mContentContainer;
        }
        return (ViewGroup)this.findViewById(0x1020002);
    }

    public void setMenuView(int layoutResId) {
        this.mMenuContainer.removeAllViews();
        this.mMenuView = LayoutInflater.from((Context)this.getContext()).inflate(layoutResId, (ViewGroup)this.mMenuContainer, false);
        this.mMenuContainer.addView(this.mMenuView);
    }

    public void setMenuView(View view) {
        this.setMenuView(view, new ViewGroup.LayoutParams(-1, -1));
    }

    public void setMenuView(View view, ViewGroup.LayoutParams params) {
        this.mMenuView = view;
        this.mMenuContainer.removeAllViews();
        this.mMenuContainer.addView(view, params);
    }

    public View getMenuView() {
        return this.mMenuView;
    }

    public void setContentView(int layoutResId) {
        switch (this.mDragMode) {
            case 0: {
                this.mContentContainer.removeAllViews();
                LayoutInflater.from((Context)this.getContext()).inflate(layoutResId, (ViewGroup)this.mContentContainer, true);
                break;
            }
            case 1: {
                this.mActivity.setContentView(layoutResId);
            }
        }
    }

    public void setContentView(View view) {
        this.setContentView(view, new ViewGroup.LayoutParams(-1, -1));
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        switch (this.mDragMode) {
            case 0: {
                this.mContentContainer.removeAllViews();
                this.mContentContainer.addView(view, params);
                break;
            }
            case 1: {
                this.mActivity.setContentView(view, params);
            }
        }
    }

    protected void setDrawerState(int state) {
        if (state != this.mDrawerState) {
            int oldState = this.mDrawerState;
            this.mDrawerState = state;
            if (this.mOnDrawerStateChangeListener != null) {
                this.mOnDrawerStateChangeListener.onDrawerStateChange(oldState, state);
            }
        }
    }

    protected void logDrawerState(int state) {
        switch (state) {
            case 0: {
                Log.d((String)TAG, (String)"[DrawerState] STATE_CLOSED");
                break;
            }
            case 1: {
                Log.d((String)TAG, (String)"[DrawerState] STATE_CLOSING");
                break;
            }
            case 2: {
                Log.d((String)TAG, (String)"[DrawerState] STATE_DRAGGING");
                break;
            }
            case 4: {
                Log.d((String)TAG, (String)"[DrawerState] STATE_OPENING");
                break;
            }
            case 8: {
                Log.d((String)TAG, (String)"[DrawerState] STATE_OPEN");
                break;
            }
            default: {
                Log.d((String)TAG, (String)("[DrawerState] Unknown: " + state));
            }
        }
    }

    public abstract int getTouchMode();

    public abstract void setTouchMode(int var1);

    public abstract void setTouchBezelSize(int var1);

    public abstract int getTouchBezelSize();

    public void postOnAnimation(Runnable action) {
        if (Build.VERSION.SDK_INT >= 16) {
            super.postOnAnimation(action);
        } else {
            this.postDelayed(action, 16L);
        }
    }

    protected boolean fitSystemWindows(Rect insets) {
        if (this.mDragMode == 1) {
            this.mMenuContainer.setPadding(0, insets.top, 0, 0);
        }
        return super.fitSystemWindows(insets);
    }

    public final Parcelable saveState() {
        if (this.mState == null) {
            this.mState = new Bundle();
        }
        this.saveState(this.mState);
        return this.mState;
    }

    void saveState(Bundle state) {
    }

    public void restoreState(Parcelable in) {
        this.mState = (Bundle)in;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState state = new SavedState(superState);
        if (this.mState == null) {
            this.mState = new Bundle();
        }
        this.saveState(this.mState);
        state.mState = this.mState;
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.restoreState((Parcelable)savedState.mState);
    }

    static class SavedState
    extends View.BaseSavedState {
        Bundle mState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public SavedState(Parcel in) {
            super(in);
            this.mState = in.readBundle();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeBundle(this.mState);
        }
    }

    public static interface OnInterceptMoveEventListener {
        public boolean isViewDraggable(View var1, int var2, int var3, int var4);
    }

    public static interface OnDrawerStateChangeListener {
        public void onDrawerStateChange(int var1, int var2);
    }
}

