/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import net.simonvt.menudrawer.HorizontalDrawer;

public class LeftDrawer
extends HorizontalDrawer {
    private int mIndicatorTop;

    LeftDrawer(Activity activity, int dragMode) {
        super(activity, dragMode);
    }

    public LeftDrawer(Context context) {
        super(context);
    }

    public LeftDrawer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public LeftDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public void openMenu(boolean animate) {
        this.animateOffsetTo(this.mMenuSize, 0, animate);
    }

    @Override
    public void closeMenu(boolean animate) {
        this.animateOffsetTo(0, 0, animate);
    }

    @Override
    public void setDropShadowColor(int color2) {
        int endColor = color2 & 0xFFFFFF;
        this.mDropShadowDrawable = new GradientDrawable(GradientDrawable.Orientation.RIGHT_LEFT, new int[]{color2, endColor});
        this.invalidate();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = r - l;
        int height = b - t;
        int offsetPixels = (int)this.mOffsetPixels;
        this.mMenuContainer.layout(0, 0, this.mMenuSize, height);
        this.offsetMenu(offsetPixels);
        if (USE_TRANSLATIONS) {
            this.mContentContainer.layout(0, 0, width, height);
        } else {
            this.mContentContainer.layout(offsetPixels, 0, width + offsetPixels, height);
        }
    }

    private void offsetMenu(int offsetPixels) {
        if (this.mOffsetMenu && this.mMenuSize != 0) {
            int menuWidth = this.mMenuSize;
            float openRatio = ((float)menuWidth - (float)offsetPixels) / (float)menuWidth;
            if (USE_TRANSLATIONS) {
                if (offsetPixels > 0) {
                    int menuLeft = (int)(0.25f * (-openRatio * (float)menuWidth));
                    this.mMenuContainer.setTranslationX(menuLeft);
                } else {
                    this.mMenuContainer.setTranslationX(-menuWidth);
                }
            } else {
                int oldMenuLeft = this.mMenuContainer.getLeft();
                int offset = (int)(0.25f * (-openRatio * (float)menuWidth)) - oldMenuLeft;
                this.mMenuContainer.offsetLeftAndRight(offset);
                this.mMenuContainer.setVisibility(offsetPixels == 0 ? 4 : 0);
            }
        }
    }

    @Override
    protected void drawDropShadow(Canvas canvas, int offsetPixels) {
        int height = this.getHeight();
        this.mDropShadowDrawable.setBounds(offsetPixels - this.mDropShadowSize, 0, offsetPixels, height);
        this.mDropShadowDrawable.draw(canvas);
    }

    @Override
    protected void drawMenuOverlay(Canvas canvas, int offsetPixels) {
        int height = this.getHeight();
        float openRatio = (float)offsetPixels / (float)this.mMenuSize;
        this.mMenuOverlay.setBounds(0, 0, offsetPixels, height);
        this.mMenuOverlay.setAlpha((int)(185.0f * (1.0f - openRatio)));
        this.mMenuOverlay.draw(canvas);
    }

    @Override
    protected void drawIndicator(Canvas canvas, int offsetPixels) {
        if (this.mActiveView != null && this.isViewDescendant(this.mActiveView)) {
            int pos;
            Integer position = (Integer)this.mActiveView.getTag(2131034117);
            int n = pos = position == null ? 0 : position;
            if (pos == this.mActivePosition) {
                float openRatio = (float)offsetPixels / (float)this.mMenuSize;
                this.mActiveView.getDrawingRect(this.mActiveRect);
                this.offsetDescendantRectToMyCoords(this.mActiveView, this.mActiveRect);
                float interpolatedRatio = 1.0f - INDICATOR_INTERPOLATOR.getInterpolation(1.0f - openRatio);
                int interpolatedWidth = (int)((float)this.mActiveIndicator.getWidth() * interpolatedRatio);
                if (this.mIndicatorAnimating) {
                    int indicatorFinalTop = this.mActiveRect.top + (this.mActiveRect.height() - this.mActiveIndicator.getHeight()) / 2;
                    int indicatorStartTop = this.mIndicatorStartPos;
                    int diff = indicatorFinalTop - indicatorStartTop;
                    int startOffset = (int)((float)diff * this.mIndicatorOffset);
                    this.mIndicatorTop = indicatorStartTop + startOffset;
                } else {
                    this.mIndicatorTop = this.mActiveRect.top + (this.mActiveRect.height() - this.mActiveIndicator.getHeight()) / 2;
                }
                int right = offsetPixels;
                int left = right - interpolatedWidth;
                canvas.save();
                canvas.clipRect(left, 0, right, this.getHeight());
                canvas.drawBitmap(this.mActiveIndicator, (float)left, (float)this.mIndicatorTop, null);
                canvas.restore();
            }
        }
    }

    @Override
    protected int getIndicatorStartPos() {
        return this.mIndicatorTop;
    }

    @Override
    protected void initPeekScroller() {
        int dx = this.mMenuSize / 3;
        this.mPeekScroller.startScroll(0, 0, dx, 0, 5000);
    }

    @Override
    protected void onOffsetPixelsChanged(int offsetPixels) {
        if (USE_TRANSLATIONS) {
            this.mContentContainer.setTranslationX(offsetPixels);
            this.offsetMenu(offsetPixels);
            this.invalidate();
        } else {
            this.mContentContainer.offsetLeftAndRight(offsetPixels - this.mContentContainer.getLeft());
            this.offsetMenu(offsetPixels);
            this.invalidate();
        }
    }

    @Override
    protected boolean isContentTouch(MotionEvent ev) {
        return ev.getX() > this.mOffsetPixels;
    }

    @Override
    protected boolean onDownAllowDrag(MotionEvent ev) {
        return !this.mMenuVisible && this.mInitialMotionX <= (float)this.mTouchSize || this.mMenuVisible && this.mInitialMotionX >= this.mOffsetPixels;
    }

    @Override
    protected boolean onMoveAllowDrag(MotionEvent ev, float diff) {
        return !this.mMenuVisible && this.mInitialMotionX <= (float)this.mTouchSize && diff > 0.0f || this.mMenuVisible && this.mInitialMotionX >= this.mOffsetPixels;
    }

    @Override
    protected void onMoveEvent(float dx) {
        this.setOffsetPixels(Math.min(Math.max(this.mOffsetPixels + dx, 0.0f), (float)this.mMenuSize));
    }

    @Override
    protected void onUpEvent(MotionEvent ev) {
        int offsetPixels = (int)this.mOffsetPixels;
        if (this.mIsDragging) {
            this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
            int initialVelocity = (int)this.mVelocityTracker.getXVelocity();
            this.mLastMotionX = ev.getX();
            this.animateOffsetTo(this.mVelocityTracker.getXVelocity() > 0.0f ? this.mMenuSize : 0, initialVelocity, true);
        } else if (this.mMenuVisible && ev.getX() > (float)offsetPixels) {
            this.closeMenu();
        }
    }
}

